<?php
namespace model;
use DATABASE\Model;
use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Entity\CustomersEntity;

class InvoiceBackReports  extends Model {
    public $_table = 'tblOrders';
    public $_key = 'order_id';
    public $_Entity = \model\Entity\OrdersEntity::class;


    public static function getReport($start_date, $end_date, $customer_id, $payment_type, $stock_type)
    {

        $query = self::Db();
        $query->where('order_status','=', 4);
        if ($customer_id and $customer_id!="all") $query->where('customer_id','=', $customer_id);
        if ($payment_type and $payment_type!="all") $query->where('order_payment_type','=', $payment_type);
        if ($stock_type and $stock_type!="all") $query->where('stock_type','=', $stock_type);
        if ($start_date) {
            $query->where('order_date', '>=', date("Y/m/d H:i:s",$start_date));
        }
        if ($end_date) {
            $query->where('order_date', '<=',  date("Y/m/d H:i:s",$end_date));
        }
        return $query->get();

    }


}