<?php
namespace model;
use DATABASE\Model;
use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Entity\CustomersEntity;

class TransferReports  extends Model {
    public $_table = 'tblmainStockReports';
    public $_key = 'main_stock_report_id';
    public $_Entity = \model\Entity\mainStockReportsEntity::class;


    public static function getReport($start_date, $end_date, $inputStock, $outputStock)
    {

        $query = self::Db();
        if ($inputStock) {
            $query->where('stock_type','=', $inputStock)->where('transfer_type', '=', 1);
        }

        if ($outputStock) {
            $query->where('stock_type','=', $outputStock)->where('transfer_type', '=', 2);
        }
        $query->where('transfer_type', '>', 0);

        if ($start_date) {

            $query->where('log_date', '>=', date("Y/m/d H:i:s",$start_date));
        }
        if ($end_date) {
            $query->where('log_date', '<=',  date("Y/m/d H:i:s",$end_date));
        }
//        var_dump($query->showQuery());
        return $query->get();

    }


}