class PaginationClass {
    constructor() {
        this.limitElement = $(".fwPaginationLimit")
        this.paginationBox = $(".fwPaginationBox")
        this.searchFields = []

        this.path = 'notFound';
    }

    set currentPath(value) {
        this.path = value;
    }

    onPageChanged = (pageNum) => {
    }
    onLimitChanged = (limit) => {
    }

    paginate() {
        this.limitElement = $(".fwPaginationLimit");
        this.fwPaginationSearch = $(".fwPaginationSearch");
        this.paginationBox = $(".fwPaginationBox");
        this.searchFields = $(this.fwPaginationSearch).data('fields');
        const visiblePages = 20; // تعداد صفحات قابل نمایش
        const ellipsis = '<li class="page-item disabled"><span class="page-link">...</span></li>';

        const instance = this;
        $(this.limitElement).on('change', function () {
            instance.changeLimit($(this).val())
        });
        $(this.fwPaginationSearch).on('change', function () {
            instance.doSearch($(this).val())
        });
        $.ajax({
            url: instance.path,
            type: "POST",

            data: {
                controller_type: 'fwPagination_getPaginationInfo',
            },
            success: res => {
                let limit, currentPage, totalPages;
                try {
                    if (res.isOk) {
                        this.togglePaginationBody();
                        $(".usePaginationToggleFilters").click()
                        limit = res.limit;
                        currentPage = res.currentPage;
                        totalPages = res.totalPages;
                        if ($(instance.limitElement).data('select2')) {
                            $(instance.limitElement).select2('destroy');
                        }
                        $(instance.limitElement).find(`option[value=${limit}]`).attr('selected', true).prop('selected', true)
                        $(instance.limitElement).select2();
                        $(instance.paginationBox).empty();

                        $(instance.paginationBox).append(`<li class="page-item previous ${(totalPages - currentPage) === totalPages ? 'disabled' : ''}"><a data-num="${currentPage}" class="page-link fwPaginationPageLink" href="#">قبلی</a></li>`);

                        for (let i = 1; i <= totalPages; i++) {

                            $(instance.paginationBox).append(`<li class="page-item ${(currentPage + 1) === i ? 'active ' : ''}"><a data-num="${i}" class="page-link fwPaginationPageLink" href="#">${i}</a></li>`);
                        }

                        // for (let i = 1; i <= totalPages; i++) {
                        //     if (i <= visiblePages || i > totalPages - visiblePages || (i >= currentPage - Math.floor(visiblePages / 2) && i <= currentPage + Math.floor(visiblePages / 2))) {
                        //         $(instance.paginationBox).append(`<li class="page-item ${(currentPage + 1) === i ? 'active ' : ''}"><a data-num="${i}" class="page-link fwPaginationPageLink" href="#">${i}</a></li>`);
                        //     } else if ($(instance.paginationBox).children().last().html() !== ellipsis) {
                        //         $(instance.paginationBox).append(ellipsis);
                        //     }
                        // }

                        $(instance.paginationBox).append(`<li class="page-item next ${currentPage + 1 === totalPages ? 'disabled' : ''}"><a class="page-link fwPaginationPageLink" data-num="${currentPage + 2}" href="#">بعدی</a></li>`);
                    } else {
                        console.error(`The controller present at ${instance.path} is not using the ControllerPagination trait, hence it can't return the needed info for paginating`)
                    }
                } catch (e) {
                    console.error('error')
                }
            }
        });
    }


    goToNthPage(num) {
        $.loader();

        const instance = this;
        $.ajax({
            url: instance.path,
            type: "POST",
            data: {
                controller_type: 'fwPagination_goToNthPage',
                num: num - 1,
            },
            success: res => {
                $.loader();
                $("#fw-content").html(res);
                instance.onPageChanged(num);
            }
        });
    }

    changeLimit(num) {
        const instance = this;

        $.loader();
        $.ajax({
            url: instance.path,
            type: "POST",
            data: {
                controller_type: 'fwPagination_changeLimit',
                limit: num,
            },
            success: res => {
                $.loader();
                $("#fw-content").html(res);
                instance.onLimitChanged(num);
            }
        });
    }

    togglePaginationBody() {
        $(".usePaginationToggleFilters").on('click',function () {
            const card = $(this).parents('.card').find('.card-body.usePaginationBody');
            if ($(card).is(':visible')){
                $(card).slideUp(100).removeClass('d-flex');
                $(this).removeClass('btn-secondary').addClass('btn-dark');
            } else  {
                $(card).slideDown(100).addClass('d-flex');
                $(this).removeClass('btn-dark').addClass('btn-secondary');
            }
        });
    }


    doSearch(query) {
        const instance = this;
        this.onSearch(query, instance);
    }

    onSearch = (query, instance) => {
        $.loader();
        $.ajax({
            url: instance.path,
            type: "POST",
            data: {
                controller_type: 'fwPagination_search',
                fields: instance.searchFields,
                query: query,
            },
            success: res => {
                $.loader();
                $("#fw-content").html(res);
            }
        });
    }
}

export const Pagination = new PaginationClass();

$(document).on('click', '.fwPaginationPageLink', function (e) {
    e.preventDefault();
    if (!$(this).hasClass('active')) {
        Pagination.goToNthPage($(this).data('num'));
    }
});
