<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;

class AboutUs extends View
{

    public $SingularName = 'درباره ما';
    public $PluralName = 'درباره ما';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refresh()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('تصویر'),
                                                                    HtmlTags::Th('توضیحات'),
                                                                    HtmlTags::Th('مالیات')->Width('100'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    "showImage" => "main_image",
                                                                    'main_text',
                                                                    'tax',
                                                                ], false, true,false,true)
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }

    public function Form()
    {
        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .

                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('بخش بالای صفحه') .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('تصویر اول') .
                                        $this->Html()->ImageInput('image1') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('تصویر دوم') .
                                        $this->Html()->ImageInput('image2') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('تصویر سوم') .
                                        $this->Html()->ImageInput('image3') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label( 'عنوان اول') .
                                        $this->Html()->Input('title1') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('عنوان دوم') .
                                        $this->Html()->Input('title2') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('عنوان سوم') .
                                        $this->Html()->Input('title3') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('متن اول') .
                                        $this->Html()->TextArea('text1') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('متن دوم') .
                                        $this->Html()->TextArea('text2') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('متن سوم') .
                                        $this->Html()->TextArea('text3') .
                                        $this->Html()->FormGroupEnd() .


                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('بخش پایین صفحه') .

                                        $this->Html()->FormGroupStart(8) .
                                        $this->Html()->Label('متن ') .
                                        $this->Html()->TextArea('main_text') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('تصویر ') .
                                        $this->Html()->ImageInput('main_image') .
                                        $this->Html()->FormGroupEnd() .

                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('مالیات بر ارزش افزوده') .

                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('مالیات') .
                                        $this->Html()->Percent('tax') .
                                        $this->Html()->FormGroupEnd() .

                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('پاورقی صفخات') .

                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('پاورقی') .
                                        $this->Html()->TextArea('footer') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }

    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }

    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
        