<?php
namespace view;
use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;
class Banners extends View
{

    public $SingularName = 'اسلایدر';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('تصویر اسلایدر'),
                                                                    HtmlTags::Th('تیتر اسلایدر'),
                                                                    HtmlTags::Th('عنوان اول اسلایدر'),
                                                                    HtmlTags::Th('عنوان دوم اسلایدر'),
                                                                    HtmlTags::Th('متن اسلایدر'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'showImage'=>'banner_image',
                                                                    'banner_title',
                                                                    'banner_first_header',
                                                                    'banner_second_header',
                                                                    'banner_body'
                                                                ])
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }
    
    public function Form()
    {
        return $this->Html()->BreadCrumbs() .HtmlTags::Section('.content')
    ->Content(
        HtmlTags::Div('.row')
            ->Content(
                HtmlTags::Div('.col-md-12')->Content(
                    HtmlTags::Div('.card.card-primary.card-outline')
                        ->Content(
                            HtmlTags::Div('.card-header')
                                ->Content(
                                    $this->Html()->CardTitle(),
                                    $this->Html()->refreshAndBack()
                                ),
                                    $this->Html()->FormStart().

                                    HtmlTags::Div('.alert.bg-dark.w-100')->Content('اطلاعات پایه') .

                                    $this->Html()->FormGroupStart(6) .
                                    $this->Html()->Label('تصویر اسلایدر') .
                                    $this->Html()->ImageInput('banner_image') .
                                    $this->Html()->FormGroupEnd().

                                    $this->Html()->FormGroupStart(6).
                                    $this->Html()->Label('لینک اسلایدر').
                                    $this->Html()->Input('banner_link','banner_link').
                                    $this->Html()->FormGroupEnd().

                                    $this->Html()->FormGroupStart(6).
                                    $this->Html()->Label('تیتر اسلایدر').
                                    $this->Html()->Input('banner_title','banner_title').
                                    $this->Html()->FormGroupEnd().

                                    $this->Html()->FormGroupStart(12).
                                    $this->Html()->Label('عنوان اول اسلایدر').
                                    $this->Html()->TextArea('banner_first_header','banner_first_header').
                                    $this->Html()->FormGroupEnd().

                                    $this->Html()->FormGroupStart(12).
                                    $this->Html()->Label('عنوان دوم اسلایدر').
                                    $this->Html()->TextArea('banner_second_header','banner_second_header').
                                    $this->Html()->FormGroupEnd().

                                    $this->Html()->FormGroupStart(12).
                                    $this->Html()->Label('متن اسلایدر').
                                    $this->Html()->TextArea('banner_body','banner_body').
                                    $this->Html()->FormGroupEnd().



                                    $this->Html()->CardFooter()
                        )
                )
            )
    );
    }
    
    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }
    
    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }
    
    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }
    
    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
