<?php
namespace view;
use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;
class ContactUs extends View
{

    public $SingularName = 'اطلاعات';
    public $PluralName = 'تماس با ما';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refresh()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('آدرس'),
                                                                    HtmlTags::Th('ایمیل'),
                                                                    HtmlTags::Th('موبایل'),
                                                                    HtmlTags::Th('شماره تماس'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'contact_us_address',
                                                                    'contact_us_email',
                                                                    'contact_us_mobile',
                                                                    'contact_us_phone'
                                                                ],false)
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }

    public function Form()
    {
        return $this->Html()->BreadCrumbs() .HtmlTags::Section('.content')
    ->Content(
        HtmlTags::Div('.row')
            ->Content(
                HtmlTags::Div('.col-md-12')->Content(
                    HtmlTags::Div('.card.card-primary.card-outline')
                        ->Content(
                            HtmlTags::Div('.card-header')
                                ->Content(
                                    $this->Html()->CardTitle(),
                                    $this->Html()->refreshAndBack()
                                ),
                                    $this->Html()->FormStart().

                                    HtmlTags::Div('.alert.bg-dark.w-100')->Content('اطلاعات پایه') .

                                    $this->Html()->FormGroupStart(12) .
                                    $this->Html()->Label('آدرس') .
                                    $this->Html()->TextArea('contact_us_address','contact_us_address') .
                                    $this->Html()->FormGroupEnd().

                                    $this->Html()->FormGroupStart(4) .
                                    $this->Html()->Label('ایمیل') .
                                    $this->Html()->Email('contact_us_email','contact_us_email') .
                                    $this->Html()->FormGroupEnd().

                                    $this->Html()->FormGroupStart(4) .
                                    $this->Html()->Label('موبایل') .
                                    $this->Html()->Mobile('contact_us_mobile','contact_us_mobile') .
                                    $this->Html()->FormGroupEnd().

                                    $this->Html()->FormGroupStart(4) .
                                    $this->Html()->Label('شماره تماس') .
                                    $this->Html()->Input('contact_us_phone','contact_us_phone') .
                                    $this->Html()->FormGroupEnd().

                                    $this->Html()->FormGroupStart(3) .
                                    $this->Html()->Label('آدرس فیسبوک') .
                                    $this->Html()->Input('contact_us_facebook','contact_us_facebook') .
                                    $this->Html()->FormGroupEnd().

                                    $this->Html()->FormGroupStart(3) .
                                    $this->Html()->Label('آدرس اینستاگرام') .
                                    $this->Html()->Input('contact_us_instagram','contact_us_instagram') .
                                    $this->Html()->FormGroupEnd().

                                    $this->Html()->FormGroupStart(3) .
                                    $this->Html()->Label('آدرس واتس اپ') .
                                    $this->Html()->Input('contact_us_whatsapp','contact_us_whatsapp') .
                                    $this->Html()->FormGroupEnd().

                                    $this->Html()->FormGroupStart(3) .
                                    $this->Html()->Label('آدرس تلگرام') .
                                    $this->Html()->Input('contact_us_telegram','contact_us_telegram') .
                                    $this->Html()->FormGroupEnd().

                                    $this->Html()->CardFooter()
                        )
                )
            )
    );
    }
    
    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }
    
    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }
    
    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }
    
    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
