<?php
namespace view;
use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;
class CustomerAddresses extends View
{

    public $SingularName = 'آدرس مشتری';
    public $PluralName = 'آدرس مشتریان';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('نام مشتری'),
                                                                    HtmlTags::Th('استان'),
                                                                    HtmlTags::Th('شهر'),
                                                                    HtmlTags::Th('منطفه'),
                                                                    HtmlTags::Th('آدرس'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'customer_id'=>function($item){
                                                                    $a= \model\Customers::get($item);
                                                                    return $a->customer_first_name.' '.$a->customer_last_name;
                                                                    },
                                                                    'state_id'=>function($item){
                                                                    return \model\States::get($item)->state_name;
                                                                    },
                                                                    'city_id'=>function($item){
                                                                    return \model\Cities::get($item)->city_name;
                                                                    },
                                                                    'district_id'=>function($item){
                                                                    return \model\Districts::get($item)->district_name;
                                                                    },
                                                                    'customer_address'
                                                                ])
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }
    
    public function Form()
    {
        return $this->Html()->BreadCrumbs() .HtmlTags::Section('.content')
    ->Content(
        HtmlTags::Div('.row')
            ->Content(
                HtmlTags::Div('.col-md-12')->Content(
                    HtmlTags::Div('.card.card-primary.card-outline')
                        ->Content(
                            HtmlTags::Div('.card-header')
                                ->Content(
                                    $this->Html()->CardTitle(),
                                    $this->Html()->refreshAndBack()
                                ),
                                    $this->Html()->FormStart().

                                    $this->Html()->FormGroupStart(6).
                                    $this->Html()->Label('انتخاب مشتری').
                                    $this->Html()->Select('customer_id','customer_id',\model\Customers::toOption()).
                                    $this->Html()->FormGroupEnd().

                                    $this->Html()->FormGroupStart(6).
                                    $this->Html()->Label('نام آدرس').
                                    $this->Html()->Input('customer_address_name','customer_address_name').
                                    $this->Html()->FormGroupEnd().

                                    $this->Html()->FormGroupStart(4).
                                    $this->Html()->Label('انتخاب استان').
                                    $this->Html()->Select('state_id','state_id',\model\States::toOption()).
                                    $this->Html()->FormGroupEnd().

                                    $this->Html()->FormGroupStart(4).
                                    $this->Html()->Label('انتخاب شهر').
                                    $this->Html()->Select('city_id','city_id',\model\Cities::toOption()).
                                    $this->Html()->FormGroupEnd().

                                    $this->Html()->FormGroupStart(4).
                                    $this->Html()->Label('انتخاب منطقه').
                                    $this->Html()->Select('district_id','district_id',\model\Districts::toOption()).
                                    $this->Html()->FormGroupEnd().

                                    $this->Html()->FormGroupStart(12).
                                    $this->Html()->Label('آدرس کامل').
                                    $this->Html()->TextArea('customer_address','customer_address').
                                    $this->Html()->FormGroupEnd().

                                    $this->Html()->FormGroupStart(12).
                                    $this->Html()->Label('انتخاب آدرس روی نقشه').
                                    $this->MapMarker('customer_address_latitude','customer_address_longitude').
                                    $this->Html()->FormGroupEnd().


                                    $this->Html()->CardFooter()
                        )
                )
            )
    );
    }
    
    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }
    
    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }
    
    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }
    
    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
