<?php

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;

class Discounts extends View
{

    public $SingularName = 'تخفیف';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('کد تخفیف'),
                                                                    HtmlTags::Th('درصد یا مبلغ'),
                                                                    HtmlTags::Th('مقدار'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'discount_code',
                                                                    'discount_percent_or_price' => function ($item) {
                                                                        return $item == 1 ? "مبلغی" : 'درصدی';
                                                                    },
                                                                    'discount_id' => function ($item) {
                                                                        $d = \model\Discounts::get($item);
                                                                        if ($d->discount_percent_or_price == 1) {
                                                                            return $d->discount_amount . ' تومان';
                                                                        } else {
                                                                            return $d->discount_amount . ' %';
                                                                        }
                                                                    }
                                                                ])
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }

    public function Form()
    {
        $priceOrPercent = collect([
                HtmlTags::Option()->Selected()->Disabled()->Content('لطفا یک مورد را انتخاب کنید'),
                HtmlTags::Option()->Value(1)->Content('مبلغی'),
                HtmlTags::Option()->Value(2)->Content('درصدی'),
            ]
        )->join('');

        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .

                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('اطلاعات پایه') .

                                        $this->Html()->FormGroupStart() .
                                        $this->Html()->Label('تعریف کد تخفیف') .
                                        $this->Html()->Input('discount_code', 'discount_code') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart() .
                                        $this->Html()->Label('نوع تخفیف') .
                                        $this->Html()->Select('discount_percent_or_price', 'discount_percent_or_price', $priceOrPercent) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4, 'd-none discountAmount') .
                                        $this->Html()->Label('مقدار تخفیف') .
                                        HtmlTags::Div(".amount")->Content() .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }

    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }

    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
