<?php
namespace view;
use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;
class Levels extends View
{

    public $SingularName = 'سطح عضویت';
    public $PluralName = 'سطوح عضویت';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('سطح عضویت'),
//                                                                    HtmlTags::Th('درصد تخفیف'),
                                                                    HtmlTags::Th('حداقل میزان خرید'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'level_name',
//                                                                    'discount_percent'=>function($item){
//                                                                    return " % ".en_to_fa($item);
//                                                                    },
                                                                   'least_price'=>function($item){
                                                                       return $item==0?en_to_fa(0).' تومان':price_format($item);
                                                                   }
                                                                ],true,true,false,true)
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }
    
    public function Form()
    {
        return $this->Html()->BreadCrumbs() .HtmlTags::Section('.content')
    ->Content(
        HtmlTags::Div('.row')
            ->Content(
                HtmlTags::Div('.col-md-12')->Content(
                    HtmlTags::Div('.card.card-primary.card-outline')
                        ->Content(
                            HtmlTags::Div('.card-header')
                                ->Content(
                                    $this->Html()->CardTitle(),
                                    $this->Html()->refreshAndBack()
                                ),
                                    $this->Html()->FormStart().

                                    HtmlTags::Div('.alert.bg-dark.w-100')->Content('اطلاعات پایه') .


                                    $this->Html()->FormGroupStart(6).
                                    $this->Html()->Label('نام سطح عضویت').
                                    $this->Html()->Input('level_name','level_name').
                                    $this->Html()->FormGroupEnd().
                                    
                                    $this->Html()->FormGroupStart(6).
                                    $this->Html()->Label('حداقل میزان خرید').
                                    $this->Html()->Price('least_price','least_price').
                                    $this->Html()->FormGroupEnd().

                                    $this->Html()->FormGroupStart(12).
                                    $this->tableContent().
                                    $this->Html()->FormGroupEnd().

                                    $this->Html()->FormGroupStart(12).
                                    $this->brandContent().
                                    $this->Html()->FormGroupEnd().


                                    $this->Html()->CardFooter()
                        )
                )
            )
    );
    }

    private function tableContent(){
        return HtmlTags::Div(".w-100.tableContent")->Content(
            HtmlTags::Table('.table.table-striped.no-data-table')->Content(
                HtmlTags::Thead()->Content(
                    HtmlTags::Tr()->Content(
                        HtmlTags::Th()->Content(
                            '#'
                        ),
                        HtmlTags::Th()->Content(
                            'نام دسته بندی'
                        ),
                        HtmlTags::Th()->Content(
                            'مقدار تخفیف'
                        )
                    )
                ),
                HtmlTags::Tbody("#categories")->Content()
            )
        );
    }
    private function brandContent(){
        return HtmlTags::Div(".w-100.tableContent")->Content(
            HtmlTags::Table('.table.table-striped.no-data-table')->Content(
                HtmlTags::Thead()->Content(
                    HtmlTags::Tr()->Content(
                        HtmlTags::Th()->Content(
                            '#'
                        ),
                        HtmlTags::Th()->Content(
                            'نام برند'
                        ),
                        HtmlTags::Th()->Content(
                            'مقدار تخفیف'
                        )
                    )
                ),
                HtmlTags::Tbody("#brands")->Content()
            )
        );
    }

    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }
    
    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }
    
    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }
    
    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
