<?php
namespace view;
use DOMWrap\Document;
use FwHtml\Elements\Attrs\Style;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;
class MiddleSiteBanners extends View
{

    public $SingularName = 'بنر ها ';
    public $PluralName = 'بنر ها ';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refresh()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('تصویر اول'),
                                                                    HtmlTags::Th('تصویر دوم'),
                                                                    HtmlTags::Th('تصویر سوم'),
                                                                    HtmlTags::Th('تصویر چهارم'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'right_image'=>function($item){
                                                                        return HtmlTags::Img()->Src("https://zamanzeevar.negarine.com/admin/src/images/MiddleSiteBanners/".$item)->Attrs(['width' => '300']);
                                                                    },
                                                                    'left_image'=>function($item){
                                                                        return HtmlTags::Img()->Src("https://zamanzeevar.negarine.com/admin/src/images/MiddleSiteBanners/".$item)->Attrs(['width' => '300']);
                                                                    },
                                                                    'right_image_2'=>function($item){
                                                                        return HtmlTags::Img()->Src("https://zamanzeevar.negarine.com/admin/src/images/MiddleSiteBanners/".$item)->Attrs(['width' => '300']);
                                                                    },
                                                                    'left_image_2'=>function($item){
                                                                        return HtmlTags::Img()->Src("https://zamanzeevar.negarine.com/admin/src/images/MiddleSiteBanners/".$item)->Attrs(['width' => '300']);
                                                                    },

                                                                ],false,true,false,true)
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }
    
    public function Form()
    {
        return $this->Html()->BreadCrumbs() .HtmlTags::Section('.content')
    ->Content(
        HtmlTags::Div('.row')
            ->Content(
                HtmlTags::Div('.col-md-12')->Content(
                    HtmlTags::Div('.card.card-primary.card-outline')
                        ->Content(
                            HtmlTags::Div('.card-header')
                                ->Content(
                                    $this->Html()->CardTitle(),
                                    $this->Html()->refreshAndBack()
                                ),
                                    $this->Html()->FormStart().

                                    HtmlTags::Div('.alert.bg-dark.w-100')->Content('اطلاعات پایه') .

                                    $this->Html()->FormGroupStart(4) .
                                    $this->Html()->Label('تصویر اول') .
                                    $this->Html()->ImageInput('right_image') .
                                    $this->Html()->FormGroupEnd().

                                    $this->Html()->FormGroupStart(4) .
                                    $this->Html()->Label('تصویر دوم') .
                                    $this->Html()->ImageInput('left_image') .
                                    $this->Html()->FormGroupEnd().

                                    $this->Html()->FormGroupStart(4) .
                                    $this->Html()->Label('تصویر سوم') .
                                    $this->Html()->ImageInput('right_image_2') .
                                    $this->Html()->FormGroupEnd().

                                    $this->Html()->FormGroupStart(4) .
                                    $this->Html()->Label('تصویر چهارم') .
                                    $this->Html()->ImageInput('left_image_2') .
                                    $this->Html()->FormGroupEnd().


                                    $this->Html()->CardFooter()
                        )
                )
            )
    );
    }
    
    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }
    
    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }
    
    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }
    
    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
