<?php

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Attrs\Style;
use FwHtml\Elements\Tags\Main\HtmlTags;
use model\PaymentTable;
use View;
use Views\Html;

class Orders extends View
{

    public $SingularName = 'سفارش';
    public $PluralName = 'سفارشات';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refresh()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('مشتری'),
                                                                    HtmlTags::Th('محصولات'),
                                                                    HtmlTags::Th('هزینه کل'),
                                                                    HtmlTags::Th('وضعیت')->Width('100'),
                                                                    HtmlTags::Th('نحوه پرداخت')->Width('100'),
                                                                    HtmlTags::Th('فروش از')->Width('100'),
                                                                    HtmlTags::Th('تاریخ'),
                                                                    HtmlTags::Th('آدرس'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('65')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'customer_id'=>function($item){
                                                                    $n = \model\Customers::get($item);
                                                                    return $n->customer_first_name.' '.$n->customer_last_name;
                                                                    },
                                                                    'order_products'=>function($item){
                                                                    $decode = json_decode($item);
                                                                    $output=[];
                                                                    if ($decode){
                                                                        foreach ($decode as $value => $count){
                                                                            $output[]=\model\Products::get($value)->product_name;
                                                                        }
                                                                        return implode(' / ',$output);
                                                                    }else{
                                                                        return "محصول یافت نشد";
                                                                    }

                                                                    },
                                                                    'price_format'=>'payment_price',
                                                                    'order_status'=>function($item){
                                                                        if($item==1) return "<span class='badge badge-warning'>پرداخت شده</span>";
                                                                        elseif($item==2) return "<span class='badge badge-info'>ارسال شده</span>";
                                                                        elseif($item==3) return "<span class='badge badge-success'>تحویل شده</span>";
                                                                        elseif($item==4) return "<span class='badge badge-danger'>لغو شده</span>";
                                                                        else return "<span class='badge badge-danger'>ناموفق</span>";
                                                                    },
                                                                    'order_payment_type'=>function($item){
                                                                        if($item==1) return "<span class='badge badge-success'>خرید نقدی</span>";
                                                                        elseif($item==2) return "<span class='badge badge-success'>پرداخت آنلاین</span>";
                                                                        elseif($item==3) return "<span class='badge badge-success'>واریز به حساب</span>";
                                                                        elseif($item==4) return "<span class='badge badge-warning'>خرید اعتباری</span>";
                                                                        elseif($item==5) return "<span class='badge badge-secondary'>خرید اقساطی</span>";
                                                                        elseif($item==6) return "<span class='badge badge-secondary'>هدیه</span>";
                                                                        else return "<span class='badge badge-danger'>نامشخص</span>";
                                                                    },
                                                                    'stock_type'=>function($item){
                                                                        if($item==1) return "<span class='badge badge-success'>انبار اصلی</span>";
                                                                        elseif($item==2) return "<span class='badge badge-info'>انبار نماینده</span>";
                                                                        elseif($item==3) return "<span class='badge badge-warning'>انبار امانی</span>";
                                                                        else return "<span class='badge badge-danger'>نامشخص</span>";
                                                                    },
                                                                    'order_date' => function($item){
                                                                            return jdate('Y/m/d H:i:s', $item);
                                                                    },
                                                                    'address_id'=>function($item){
                                                                    $address = \model\CustomerAddresses::get($item);
                                                                    $state = \model\States::get($address->state_id);
                                                                    $city = \model\Cities::get($address->city_id);
                                                                    return $state->state_name.' - '.$city->city_name.' <br> '.$address->customer_address;

                                                                    }
                                                                ], false, true)
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }

    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }

    public function Form()
    {
        $customer = \model\Customers::get($this->getData()->customer_id);



        $discount = 0;
        if($this->getData()->order_discount > 0){
            $discount = $this->getData()->order_discount;
        } else {
            $discountcode = json_decode($this->getData()->discount_code);
            if($discountcode->usage == 'price') $discount = $discountcode->amount;
            elseif ($discountcode->usage == 'percent') $discount = ($this->getData()->products_price * $discountcode->amount / 100);
        }

        $address = \model\CustomerAddresses::get($this->getData()->address_id);
        $state = \model\States::get($address->state_id);
        $city = \model\Cities::get($address->city_id);

        $distribute = \model\Distributions::get($this->getData()->distribution_id);

        $payment = PaymentTable::getOneFiltered('payment_resnum' ,$this->getData()->order_id);
        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .

                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('اطلاعات مشتری') .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('نام') .
                                        $this->Html()->Input('customer_first_name','customer_first_name',$customer->customer_first_name,false,true,'form-control') .
                                        $this->Html()->FormGroupEnd(),

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('نام خانوادگی') .
                                        $this->Html()->Input('customer_last_name','customer_last_name',$customer->customer_last_name,false,true,'form-control') .
                                        $this->Html()->FormGroupEnd(),

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('شماره همراه') .
                                        $this->Html()->Input('customer_mobile','customer_mobile',$customer->customer_mobile,false,true,'form-control') .
                                        $this->Html()->FormGroupEnd(),




                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('اطلاعات ارسال') .

                                        $this->Html()->FormGroupStart(2) .
                                        $this->Html()->Label('استان') .
                                        $this->Html()->Input('state_name','state_name',$state->state_name,false,true,'form-control') .
                                        $this->Html()->FormGroupEnd(),

                                        $this->Html()->FormGroupStart(2) .
                                        $this->Html()->Label('شهر') .
                                        $this->Html()->Input('city_name','city_name',$city->city_name,false,true,'form-control') .
                                        $this->Html()->FormGroupEnd(),

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('آدرس تحویل') .
                                        $this->Html()->Input('customer_address','customer_address',$address->customer_address,false,true,'form-control') .
                                        $this->Html()->FormGroupEnd(),

                                        $this->Html()->FormGroupStart(2) .
                                        $this->Html()->Label('کدپستی') .
                                        $this->Html()->Input('customer_postcode','customer_postcode',$address->customer_postcode,false,true,'form-control') .
                                        $this->Html()->FormGroupEnd(),


                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('نحوه ارسال') .
                                        $this->Html()->FormGroupStart(5).
                                        $this->Html()->Label('نحوه ارسال').
                                        $this->Html()->Input('distribution_name','distribution_name',$distribute->distribution_name,false,true,'form-control') .
                                        $this->Html()->FormGroupEnd().

                                        $this->Html()->FormGroupStart(7).
                                        $this->Html()->Label('مدت ارسال').
                                        $this->Html()->Input('distribution_time','distribution_time',$distribute->distribution_time,false,true,'form-control') .
                                        $this->Html()->FormGroupEnd().


                                        $this->paymentWidget() .

                                        $this->Html()->FormGroupStart(3).
                                        $this->Html()->Label('مبلغ سفارشات').
                                        $this->Html()->Price('products_price','products_price','تومان','',false,false,'form-control',true).
                                        $this->Html()->FormGroupEnd().

                                        $this->Html()->FormGroupStart(3).
                                        $this->Html()->Label('هزینه ارسال').
                                        $this->Html()->Price('send_price','send_price','تومان','',false,false,'form-control',true).
                                        $this->Html()->FormGroupEnd(3).

                                        $this->Html()->FormGroupStart(3).
                                        $this->Html()->Label('تخفیف').
                                        $this->Html()->Price('discount','discount','تومان',$discount,true,false,'form-control',true).
                                        $this->Html()->FormGroupEnd().

                                        $this->Html()->FormGroupStart(3).
                                        $this->Html()->Label('مبلغ کل').
                                        $this->Html()->Price('payment_price','payment_price','تومان','',true,false,'form-control',true).
                                        $this->Html()->FormGroupEnd().

                                        $this->editWidget() .
                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('محصولات') .

                                        $this->Html()->FormGroupStart(12) .
                                        $this->productsWidget() .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }

    private function productsWidget()
    {
        return HtmlTags::Div()->Content(
            $this->tabContent()
        );
    }

    private function editWidget()
    {
        return HtmlTags::Div('.w-100')->Content(

            function(){
                $output=[];
                $payment = PaymentTable::getOneFiltered('payment_resnum' ,$this->getData()->order_id);
//            if($payment->payment_status == 1){
                $output[] = HtmlTags::Div('.alert.bg-dark.w-100')->Content('تغییر وضعیت سفارش');
                $output[] = $this->Html()->FormGroupStart(12) .
                    $this->Html()->Label('وضعیت سفارش') .
                    $this->Html()->Select('order_status','order_status',"<option value='1'>پرداخت شده</option><option value='2'>ارسال شده</option><option value='3'>تحویل شده</option><option value='4'>لغو شده</option>") .
                    $this->Html()->FormGroupEnd();

//            }
                return implode("",$output);
            }
        );
    }

    private function paymentWidget()
    {
        return HtmlTags::Div('.w-100')->Style(new Style([Style\Props\Display::Contents()]))->Content(

            function(){
                $output=[];
                $output[]=HtmlTags::Div('.alert.bg-dark.w-100')->Content('اطلاعات مالی') ;
                if($this->getData()->order_payment_type != 20) {
                    if(is_null($this->getData()->user_id)) {
                        $payment = PaymentTable::getOneFiltered('payment_resnum' ,$this->getData()->order_id);
                        $output[] = $this->Html()->FormGroupStart(3) .
                            $this->Html()->Label('درگاه پرداخت') .
                            $this->Html()->Input('payment_gate', 'payment_gate', $payment->payment_gate, false, true, 'form-control') .
                            $this->Html()->FormGroupEnd() .

                            $this->Html()->FormGroupStart(3) .
                            $this->Html()->Label('شناسه خرید') .
                            $this->Html()->Input('payment_id', 'payment_id', $payment->payment_id, false, true, 'form-control') .
                            $this->Html()->FormGroupEnd() .

                            $this->Html()->FormGroupStart(3) .
                            $this->Html()->Label('شناسه پرداخت') .
                            $this->Html()->Input('payment_refnum', 'payment_refnum', $payment->payment_refnum, false, true, 'form-control') .
                            $this->Html()->FormGroupEnd() .

                            $this->Html()->FormGroupStart(3) .
                            $this->Html()->Label('وضعیت پرداخت') .
                            $this->Html()->Input('payment_status', 'payment_status', $payment->payment_status == 1 ? 'موفق' : 'ناموفق', false, true, $payment->payment_status == 1 ? 'form-control badge-success' : 'form-control badge-danger') .
                            $this->Html()->FormGroupEnd() ;
                    } else {

                        $output[] = $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('شماره فاکتور') .
                            $this->Html()->Input('payment_id', 'payment_id', $this->getData()->order_id, false, true, 'form-control') .
                            $this->Html()->FormGroupEnd() .

                            $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('شماره حواله انبار') .
                            $this->Html()->Input('payment_refnum', 'payment_refnum', $this->getData()->payment_refnum, false, true, 'form-control') .
                            $this->Html()->FormGroupEnd() .

                            $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('وضعیت پرداخت') .
                            $this->Html()->Input('payment_status', 'payment_status', $this->getData()->payment_status == 1 ? 'موفق' : 'ناموفق', false, true, $this->getData()->payment_status == 1 ? 'form-control badge-success' : 'form-control badge-danger') .
                            $this->Html()->FormGroupEnd() ;
                    }

                } else {
                    switch ($this->getData()->order_payment_type){
                        case 0:
                            $paymentType = "پرداخت نشده";
                            break;
                        case 1:
                            $paymentType = "پرداخت نقدی";
                            break;
                        case 2:
                            $paymentType = "خرید آنلاین";
                            break;
                        case 3:
                            $paymentType = "واریز به حساب";
                            break;
                        case 4:
                            $paymentType = "خرید اعتباری";
                            break;
                        case 5:
                            $paymentType = "خرید اقساطی";
                            break;
                        case 6:
                            $paymentType = "هدیه";
                            break;
                    }
                    $output[] = $this->Html()->FormGroupStart(12) .
                        $this->Html()->Label('نحوه پرداخت') .
                        $this->Html()->Input('payment_type', 'payment_type', $paymentType, false, true, 'form-control') .
                        $this->Html()->FormGroupEnd() ;
                }

                return implode("",$output);
            }
        );
    }

    private function tabsWidget()
    {
        return HtmlTags::Div('.btn-group.text-center.my-5#tabWidgets')->Role('group')->Aria_label('Basic example');

    }

    private function tabContent()
    {

        return HtmlTags::Div(".w-100.tableContent")->Content(
            HtmlTags::Table('.table.table-striped.no-data-table')->Content(
                HtmlTags::Thead()->Content(
                    HtmlTags::Tr()->Content(
                        HtmlTags::Th()->Content(
                            '#'
                        ),
                        HtmlTags::Th()->Content(
                            'نام محصول'
                        ),
                        HtmlTags::Th()->Content(
                            'قیمت'
                        ),
                        HtmlTags::Th()->Content(
                            'تعداد'
                        )
                    )
                ),
                HtmlTags::Tbody("#productContent")->Content(
                    function (){
                        $output=[];
                        $i = 1;
                        $products = json_decode($this->getData()->order_products);
                        foreach ($products as $key => $value){
                            $product = \model\Products::get($key);
                            $output[]=HtmlTags::Tr()->Content(
                                HtmlTags::Td()->Content("$i"),
                                HtmlTags::Td()->Content($product->product_name),
                                HtmlTags::Td()->Content(price_format($product->product_price)),
                                HtmlTags::Td()->Content($value." عدد"),
                            );
                            $i++;
                        }
                        return implode("",$output);
                    }
                )
            )
        );
    }


    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
