$(function () {

    $('.stockDiv').hide();
    $('.paymentDiv').hide();
    calcuteAll();
    $("#customer_id").getOptions({
        url:"controllers/Persons/Customers/Customers",
        target:"address_id",
        controller_type:"getAddressByCustomerId",
        data:{
            request:"options"
        }
    })

    $("#state_id").getOptions({
        url:"controllers/BaseTables/Locations/Cities/Cities",
        target:"city_id",
        controller_type:"getCitiesByStateId",
        data:{
            request:"options"
        }
    })

    $("#city_id").getOptions({
        url: 'controllers/BaseTables/Locations/Districts/Districts',
        target: "district_id",
        controller_type: "getDistrictsByCityId",
        data: {
            request: "options"
        }
    })

    $('.stock_type').on('ifChecked', function(event) {
        $("#totalPrice").val(0);
        $("#total_price").val(0);
        $("#amountPayable").val(0);
        $("#amount_payable").val(0);
        let stockType = $(this).val();
        let roleName = $('#role_name').val();
        let partnerId = 0;
        if(roleName === "admin"){
            if(stockType === '2' || stockType === '3'){
                $('.stockDiv').show();
                $('.productDiv').hide();
            } else {
                $('.stockDiv').hide();

                $.ajax({
                    url: "controllers/Stocks/DepositeStocks/DepositeStocks",
                    type: "POST",
                    data: {
                        partnerId,
                        stockType,
                        controller_type: "getProductsInfStock"
                    }, success: function (data) {
                        $('#product_id').html(data)
                    }
                })
                $('.productDiv').show();
            }
        } else if(roleName === "partner"){
            if(stockType === '2' || stockType === '3'){
                partnerId = $('#partner_id').val();
                $('.productDiv').show();
                $(".tr").remove();
                $.ajax({
                    url: "controllers/Stocks/DepositeStocks/DepositeStocks",
                    type: "POST",
                    data: {
                        partnerId,
                        stockType,
                        controller_type: "getProductsInfStock"
                    }, success: function (data) {
                        $('#product_id').html(data)
                    }
                })
                $('.productDiv').show();
            } else {

                partnerId = 0;
                $.ajax({
                    url: "controllers/Stocks/DepositeStocks/DepositeStocks",
                    type: "POST",
                    data: {
                        partnerId,
                        stockType,
                        controller_type: "getProductsInfStock"
                    }, success: function (data) {
                        $('#product_id').html(data)
                    }
                })
                $('.productDiv').show();
            }
        }
        $(".tr").remove();
    });
    $('#customer_id').on('change', function(event) {
        let customerId = $(this).val();
        $.ajax({
            url: "controllers/Persons/Customers/Customers",
            type: "post",
            data: {
                controller_type: "getCustomerInfoById",
                customerId,
            },
            success: res => {
                $('#customer_credit').val(res);
            },
        })
        $('.paymentDiv').show();
    })
    $('#partner_id').on('change', function(event) {
        let partnerId = $(this).val();
        let stockType = $('input[name=stock_type]:checked').val();
        $('.productDiv').show();
        $(".tr").remove();
        $.ajax({
            url: "controllers/Stocks/DepositeStocks/DepositeStocks",
            type: "POST",
            data: {
                partnerId,
                stockType,
                controller_type: "getProductsInfStock"
            }, success: function (data) {
                $('#product_id').html(data)
            }
        })
    });
    $("#discount").on('keyup', function (){

        calcuteAll();
    })
    $(document).on('change','input',function(){
        let id = this.id.split("_")
        let key = id[id.length-1];
        let price = $("#product_price_" + key).val();
        let cnt = $("#product_count_" + key).val();
        let total = parseInt(price) * parseInt(cnt);
        $('#total_price_' + key).val(total);
        calcuteAll()

    });
    function calcuteAll() {
        let totalPrice = 0;
        $.each($("[id^='total_price_']"), function (){
            totalPrice += parseInt($(this).val())
        })
        let tmp = $('#discount').val().replaceAll(",", "");

        let discount = parseInt(tmp);

        if(totalPrice > 0 && discount > totalPrice) {
            discount = totalPrice;
            $('#discount').val(discount)
        }
        let amountPayable = totalPrice - discount
        if(amountPayable < 0) amountPayable = 0
        $("#totalPrice").val(totalPrice);
        $("#total_price").val(totalPrice);
        $("#amountPayable").val(amountPayable);
        $("#amount_payable").val(amountPayable);
    }
    function calculate(key) {
        let price = $("#product_price_" + key).val();
        let cnt = $("#product_count_" + key).val();
        let total = parseInt(price) * parseInt(cnt);
        $('#total_price_' + key).val(total);
        calcuteAll()
    }
    $('#product_id').on('change', function (){
        let productId = $(this).val();
        let stockType = $('input[name=stock_type]:checked').val();
        let partnerId = 0
        if($('#partner_id').is('input')){
            partnerId = $('#partner_id').val()
        } else {
            partnerId = $('#partner_id').find(":selected").val();
        }
        if(productId > 0) {
            $.ajax({
                url: "controllers/Stocks/DepositeStocks/DepositeStocks",
                type: "POST",
                data: {
                    productId,
                    stockType,
                    partnerId,
                    controller_type: "getProductInformation"
                }, success: function (data) {
                    let obj = JSON.parse(data);
                    if($('#productId_' + productId).length === 0) {
                        let sum = obj.product_price;
                        $('#shopBody').append("<tr id='productId_" + productId + "' data-id='" + productId + "' class='tr'>")
                        $('#productId_' + productId).append("<td>" + obj.product_name +"</td>")
                        $('#productId_' + productId).append("<td>" + obj.product_price +"</td>")
                        $('#productId_' + productId).append("<td><input type='number' value='1' min='1' max='" + obj.product_count + "'  class='form-control' name='product_count_"  + productId + "' id='product_count_" + productId + "' autocomplete='off' required=''  >")
                        $('#productId_' + productId).append("<input type='hidden' value='" + productId + "'  class='form-control' name='product_id_"  + productId + "' id='product_id_" + productId + "' autocomplete='off' required=''  >")
                        $('#productId_' + productId).append("<input type='hidden' value='" + obj.product_price + "'  class='form-control' name='product_price_"  + productId + "' id='product_price_" + productId + "' autocomplete='off' required=''  ></td>")
                        $('#productId_' + productId).append("<td><input type='number' value='" + sum + "'  class='form-control' name='total_price_"  + productId + "' id='total_price_" + productId + "' disabled ></td>")
                        $('#productId_' + productId).append("<td><button type='button' name='deleteRow_" + productId + "' id='deleteRow_" + productId + "' data-id='" + productId + "' class='btn btn-danger'><i class='fa fa-trash'></i></button></td>")
                        $('#shopBody').append("</tr>")
                    } else {
                        let val = parseInt($('#product_count_' + productId).val());
                        val = val + 1;
                        if(val <= obj.product_count){
                            $('#product_count_' + productId).val(val)
                        }
                        calculate(productId)

                    }
                    calcuteAll();



                    $("[id^='deleteRow_']").click(function () {
                        let id = $(this).data('id');
                        console.log(id);
                        Swal.fire({
                            icon: 'warning',
                            title: 'هشدار!',
                            text: 'حذف یک سطر، غیر قابل بازگشت و بازیابی می باشد، برای ادامه عملیات اجازه میدهید؟',
                            confirmButtonText: 'بله، اجازه میدهم!',
                            confirmButtonColor: '#00e92e',
                            cancelButtonText: 'خیر، اجازه نمیدهم!',
                            cancelButtonColor: '#e9342b',
                            showCancelButton: true,
                            reverseButtons: true,
                            allowOutsideClick: false,
                            allowEscapeKey: false,
                        }).then((res) => {
                            console.log(res)
                            if (res.value) {
                                $("#productId_" + id).remove();
                                calcuteAll()



                            }
                        });
                    })

                }
            })
        }
    });
    $("[id^='deleteRow_']").click(function () {
        let id = $(this).data('id');
        let productId = $(this).data('productid');
        Swal.fire({
            icon: 'warning',
            title: 'هشدار!',
            text: 'حذف یک سطر، غیر قابل بازگشت و بازیابی می باشد، برای ادامه عملیات اجازه میدهید؟',
            confirmButtonText: 'بله، اجازه میدهم!',
            confirmButtonColor: '#00e92e',
            cancelButtonText: 'خیر، اجازه نمیدهم!',
            cancelButtonColor: '#e9342b',
            showCancelButton: true,
            reverseButtons: true,
            allowOutsideClick: false,
            allowEscapeKey: false,
        }).then((res) => {
            if (res.dismiss !== Swal.DismissReason.cancel) {
                $("#productId_" + id).remove();
                calcuteAll()



            }
        });
    })
    $(document).off("click", ".addCustomer").on("click", ".addCustomer", function () {
        $("#addCustomerModal").modal('show');
        return false;
    });

    $(document).off("click", ".addCustomerAddress").on("click", ".addCustomerAddress", function () {
        $("#addCustomerAddressModal").modal('show');
        return false;
    });

    $(document).off('click', '.submitCustomer').on('click', '.submitCustomer', function () {
        let first_name = $('#customer_first_name').val();
        let last_name = $('#customer_last_name').val();
        let mobile = $('#customer_mobile').val();
        let gender = $('#customer_gender').val();
        let password = $('#customer_password').val();
        let levelId = $('#customer_level_id').val();
        let credit = $('#customer_credit').val();
        $.loader();
        $.ajax({
            url: "controllers/Persons/Customers/Customers",
            type: "post",
            data: {
                controller_type: "addCustomer",
                first_name,
                last_name,
                mobile,
                gender,
                password,
                levelId,
                credit
            },
            success: function() {
                $.loader();
                $("#addCustomerModal").modal('hide');
                $("#fw_refresh_btn").click();
            },
        })

    })

    $(document).off('click', '.submitCustomerAddress').on('click', '.submitCustomerAddress', function () {
        let customer_id = $('#customer_id_modal').val();
        let customer_address_name = $('#customer_address_name_modal').val();
        let state_id = $('#state_id').val();
        let city_id = $('#city_id').val();
        let district_id = $('#district_id').val();
        let customer_postcode = $('#customer_postcode').val();
        let customer_address = $('#customer_address_modal').val();
        $.loader();
        $.ajax({
            url: "controllers/Persons/Customers/Customers",
            type: "post",
            data: {
                controller_type: "addAddress",
                customer_id,
                customer_address_name,
                state_id,
                city_id,
                district_id,
                customer_address,
                customer_postcode
            },
            success: function() {
                $.loader();
                $("#addCustomerAddressModal").modal('hide');
                $("#fw_refresh_btn").click();
            },
        })

    })

})