<?
namespace view;
use DOMWrap\Document;
use FwAuthSystem\Main\UserObject;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\Elements\Tags\Tr;
use FwHtml\FontAwesome;
use View;
class addOrder extends View
{

    public $SingularName = 'سفارش';
    public $PluralName = 'سفارشات';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([])
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }
    
    public function Form()
    {
        $user = \FwAuthSystem\Main\UserObject::instance();
        $customerData = '<option value="" selected disabled>لطفا یک مشتری را انتخاب کنید</option>';
        $customers = \model\Customers::getAll();
        $customerCredits = [];
        foreach ($customers as $customer){
            $customerData .= '<option value="'.$customer->customer_id.'">'.$customer->customer_first_name.' '. $customer->customer_last_name.' --- '. $customer->customer_mobile.  '</option>';
            $customerCredits[$customer->customer_id] = $customer->customer_credit;
        }

        $paymentData = '<option value="" selected disabled>لطفا روش پرداخت را انتخاب کنید</option><option value="1">نقدی</option><option value="2">پرداخت آنلاین</option><option value="3">واریز به حساب</option><option value="4">اعتباری</option><option value="5">اقساطی</option><option value="6">هدیه</option>';
        $productData = '<option value="" selected disabled>لطفا یک کالا را انتخاب کنید</option>';
        if($user->getRole() == "AdminRole") {
            $products = \model\MainStocks::getAllConditioned('product_count > 0');
            foreach ($products as $product){
                $data = \model\Products::get($product->product_id);
                $productData .= '<option value="'.$data->product_id.'">'.$data->product_name.' --- موجودی در انبار اصلی:  '. $product->product_count.  ' عدد</option>';

            }
        } elseif($user->getRole() == "PartnerRole") {
            $partner = \model\Partners::Db()->where("user_id", $user->getUserId())->get()->first();
            $partnerId = $partner['partner_id'];
            $products = \model\PartnerStocks::getAllConditioned("product_count > 0 and partner_id = $partnerId");
            foreach ($products as $product){
                $data = \model\Products::get($product->product_id);
                $productData .= '<option value="'.$data->product_id.'">'.$data->product_name.' --- موجودی در انبار نماینده:  '. $product->product_count.  ' عدد</option>';

            }
        }

        return $this->Html()->BreadCrumbs() .HtmlTags::Section('.content')
    ->Content(
        HtmlTags::Div('.row')
            ->Content(
                HtmlTags::Div('.col-md-12')->Content(
                    HtmlTags::Div('.card.card-primary.card-outline')
                        ->Content(
                            HtmlTags::Div('.card-header')
                                ->Content(
                                    $this->Html()->CardTitle(),
                                    $this->Html()->refresh()
                                ),
                                    $this->Html()->FormStart().
                                    HtmlTags::Div('.alert.bg-dark.w-100')->Content('اطلاعات مشتری') .
                                    $this->Html()->FormGroupStart(11) .
                                    $this->Html()->Label('انتخاب مشتری') .
                                    $this->Html()->Select('customer_id', 'customer_id', $customerData).
                                    $this->Html()->FormGroupEnd(),

                            $this->Html()->FormGroupStart(1) .
                            HtmlTags::Button('.btn.btn-outline-success.m-2.p-2.mt-4.addCustomer')->Content(
                                HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Plus_square())
                            )->Data_('toggle', 'tooltip')
                                ->Title('افزودن مشتری'),
                            $this->Html()->FormGroupEnd(),

                            $this->Html()->FormGroupStart(11) .
                            $this->Html()->Label('آدرس مشتری') .
                            $this->Html()->Select('address_id', 'address_id', \model\CustomerAddresses::toOption()).
                            $this->Html()->FormGroupEnd(),
                            $this->Html()->FormGroupStart(1) .
                            HtmlTags::Button('.btn.btn-outline-success.m-2.p-2.mt-4.addCustomerAddress')->Content(
                                HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Plus_square())
                            )->Data_('toggle', 'tooltip')
                                ->Title('افزودن آدرس مشتری'),
                            $this->Html()->FormGroupEnd(),




                            $this->Html()->FormGroupStart(12).
                            $this->Html()->Label('نحوه ارسال').
                            $this->Html()->Select('distribution_id','distribution_id', \model\Distributions::toOption()) .
                            $this->Html()->FormGroupEnd().



                            HtmlTags::Div('.alert.bg-dark.w-100')->Content('محصولات') .

                            $this->Html()->FormGroupStart(12) .
                            $this->Html()->Label('فروش از') .
                            $this->Html()->FormGroupEnd(),

                            $this->selectRole(),

                            HtmlTags::Div('.productDiv.w-100')
                                ->Content(
                                    $this->Html()->FormGroupStart(12) .
                            $this->Html()->Label('محصولات') .
                            $this->Html()->Select('product_id', 'product_id',  $productData, false, false, false).

                                    $this->Html()->FormGroupEnd(),
                                ),



                                $this->shopCard(),
                            HtmlTags::Div('.paymentDiv.w-100')
                                ->Content(
                            HtmlTags::Div('.alert.bg-dark.w-100')->Content('نحوه پرداخت') .
                            $this->Html()->FormGroupStart(12) .
                            $this->Html()->Select('payment_type', 'payment_type',  $paymentData, false, false, false).
                            $this->Html()->Input('customer_credit', 'customer_credit', '0', false, true, '', 'hidden'),
                            $this->Html()->FormGroupEnd()
                                ),
                                    $this->Html()->CardFooter()
                        )
                )
            )
    ) . $this->addCustomerModal() .  $this->addCustomerAddressModal();
    }

    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }
    
    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }
    
    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }
    
    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    private function addCustomerModal()
    {
        return HtmlTags::Div(".modal.fade#addCustomerModal")->Content(
            HtmlTags::Div('.modal-dialog.modal-lg')->Content(
                HtmlTags::Div('.modal-content')->Content(
                    HtmlTags::Div('.modal-header')->Content(
                        HtmlTags::H4('.modal-title')->Content(
                            "افزودن مشتری"
                        ),
                        HtmlTags::Div('.pull-left')->Content(
                            HtmlTags::Button('.close')->Content('&times;')->Data_('dismiss', 'modal')->Type('button')
                        )

                    ),
                    HtmlTags::Div('.modal-body')->Content(
                        HtmlTags::Div('.row')
                            ->Content(
                                HtmlTags::Div('.col-md-12')->Content(
                                    HtmlTags::Div('.card.card-primary.card-outline')
                                        ->Content(
                                            $this->Html()->FormStart() .

                                            $this->Html()->FormGroupStart(6) .
                                            $this->Html()->Label('نام') .
                                            $this->Html()->Input('customer_first_name', 'customer_first_name') .
                                            $this->Html()->FormGroupEnd(),

                                            $this->Html()->FormGroupStart(6) .
                                            $this->Html()->Label('نام خانوادگی') .
                                            $this->Html()->Input('customer_last_name', 'customer_last_name') .
                                            $this->Html()->FormGroupEnd(),

                                            $this->Html()->FormGroupStart(6) .
                                            $this->Html()->Label('موبایل') .
                                            $this->Html()->Mobile('customer_mobile','customer_mobile') .
                                            $this->Html()->FormGroupEnd(),

                                            $this->Html()->FormGroupStart(6) .
                                            $this->Html()->Label('جنسیت') .
                                            $this->Html()->Input('customer_gender','customer_gender') .
                                            $this->Html()->FormGroupEnd(),

                                            $this->Html()->FormGroupStart(6) .
                                            $this->Html()->Label('رمز عبور') .
                                            $this->Html()->Password('customer_password') .
                                            $this->Html()->FormGroupEnd(),


                                            $this->Html()->FormGroupStart(6) .
                                            $this->Html()->Label('سطح عضویت') .
                                            $this->Html()->Select('customer_level_id','customer_level_id',\model\Levels::toOption()) .
                                            $this->Html()->FormGroupEnd(),

                                            $this->Html()->FormGroupStart(12) .
                                            $this->Html()->Label('موجودی اولیه کیف پول') .
                                            $this->Html()->Price('customer_credit','customer_credit') .
                                            $this->Html()->FormGroupEnd(),

                                            $this->Html()->CardFooter('', false, true)

                                        )
                                )
                            )
                    ),
                    HtmlTags::Div('.modal-footer.d-flex.flex-wrap.space-between')->Content(
                        HtmlTags::Button('.btn.btn-success.p-2.mr-auto.ml-0.submitCustomer')->Content(
                            "افزودن مشتری"
                        )->Data_('id', 'add'),
                        HtmlTags::Button('.btn.btn-outline-danger.p-2.m-2')->Content(
                            "انصراف"
                        )->Attrs(['type' => 'button'])->Data_('dismiss', 'modal'),

                    )
                )
            )
        );
    }

    private function addCustomerAddressModal()
    {
        $customerData = '<option value="" selected disabled>لطفا یک مشتری را انتخاب کنید</option>';
        $customers = \model\Customers::getAll();
        foreach ($customers as $customer){
            $customerData .= '<option value="'.$customer->customer_id.'">'.$customer->customer_first_name.' '. $customer->customer_last_name.' --- '. $customer->customer_mobile.  '</option>';

        }
        return HtmlTags::Div(".modal.fade#addCustomerAddressModal")->Content(
            HtmlTags::Div('.modal-dialog.modal-lg')->Content(
                HtmlTags::Div('.modal-content')->Content(
                    HtmlTags::Div('.modal-header')->Content(
                        HtmlTags::H4('.modal-title')->Content(
                            "افزودن آدرس مشتری"
                        ),
                        HtmlTags::Div('.pull-left')->Content(
                            HtmlTags::Button('.close')->Content('&times;')->Data_('dismiss', 'modal')->Type('button')
                        )

                    ),
                    HtmlTags::Div('.modal-body')->Content(
                        HtmlTags::Div('.row')
                            ->Content(
                                HtmlTags::Div('.col-md-12')->Content(
                                    HtmlTags::Div('.card.card-primary.card-outline')
                                        ->Content(
                                            $this->Html()->FormStart().

                                            $this->Html()->FormGroupStart(6).
                                            $this->Html()->Label('انتخاب مشتری').
                                            $this->Html()->Select('customer_id_modal','customer_id_modal', $customerData).
                                            $this->Html()->FormGroupEnd().

                                            $this->Html()->FormGroupStart(6).
                                            $this->Html()->Label('نام آدرس').
                                            $this->Html()->Input('customer_address_name_modal','customer_address_name_modal').
                                            $this->Html()->FormGroupEnd().

                                            $this->Html()->FormGroupStart(4).
                                            $this->Html()->Label('انتخاب استان').
                                            $this->Html()->Select('state_id','state_id',\model\States::toOption()).
                                            $this->Html()->FormGroupEnd().

                                            $this->Html()->FormGroupStart(4).
                                            $this->Html()->Label('انتخاب شهر').
                                            $this->Html()->Select('city_id','city_id',\model\Cities::toOption()).
                                            $this->Html()->FormGroupEnd().

                                            $this->Html()->FormGroupStart(4).
                                            $this->Html()->Label('انتخاب منطقه').
                                            $this->Html()->Select('district_id','district_id',\model\Districts::toOption()).
                                            $this->Html()->FormGroupEnd().

                                            $this->Html()->FormGroupStart(12).
                                            $this->Html()->Label('آدرس کامل').
                                            $this->Html()->Input('customer_address_modal','customer_address_modal').
                                            $this->Html()->FormGroupEnd(),

                                            $this->Html()->FormGroupStart(12).
                                            $this->Html()->Label('کدپستی').
                                            $this->Html()->Input('customer_postcode','customer_postcode').
                                            $this->Html()->FormGroupEnd(),

                                            $this->Html()->CardFooter('', false, true)

                                        )
                                )
                            )
                    ),
                    HtmlTags::Div('.modal-footer.d-flex.flex-wrap.space-between')->Content(
                        HtmlTags::Button('.btn.btn-success.p-2.mr-auto.ml-0.submitCustomerAddress')->Content(
                            "افزودن آدرس مشتری"
                        )->Data_('id', 'add'),
                        HtmlTags::Button('.btn.btn-outline-danger.p-2.mr-2')->Content(
                            "انصراف"
                        )->Attrs(['type' => 'button'])->Data_('dismiss', 'modal'),
                    )
                )
            )
        );
    }

    private function shopCard()
    {
        return HtmlTags::Table('.table')->Content(
            HtmlTags::Thead('.thead-dark')->Content(
                HtmlTags::Tr()->Content(
                    HtmlTags::Th()->Content(
                        'نام محصول'
                    ),
                    HtmlTags::Th()->Content(
                        'قیمت محصول'
                    ),
                    HtmlTags::Th()->Content(
                        'تعداد'
                    ),
                    HtmlTags::Th()->Content(
                        'مجموع قیمت'
                    ),
                    HtmlTags::Th()->Content(
                        'عملیات'
                    )
                )
            ),
            HtmlTags::Tbody("#shopBody")->Content(),
            HtmlTags::Tfoot("#shopFooter")->Content(
                HtmlTags::Tr()->Content(
                    HtmlTags::Td()->Content(
                        ''
                    ),
                    HtmlTags::Td()->Content(
                        ''
                    ),
                    HtmlTags::Td()->Content(
                        'جمع کل'
                    ),
                    HtmlTags::Td()->Content(
                        $this->Html()->Input('totalPrice','totalPrice', 0, false, true),
                        $this->Html()->Input('total_price','total_price', 0, false, false, 'form-control', 'hidden'),
                    )
                ),
                HtmlTags::Tr()->Content(
                    HtmlTags::Td()->Content(
                        ''
                    ),
                    HtmlTags::Td()->Content(
                        ''
                    ),
                    HtmlTags::Td()->Content(
                        'تخفیف فاکتور'
                    ),
                    HtmlTags::Td()->Content(
                        $this->Html()->Price('discount','discount', 'تومان', 0, false),
                    )
                ),
                HtmlTags::Tr()->Content(
                    HtmlTags::Td()->Content(
                        ''
                    ),
                    HtmlTags::Td()->Content(
                        ''
                    ),
                    HtmlTags::Td()->Content(
                        'قابل پرداخت'
                    ),
                    HtmlTags::Td()->Content(
                        $this->Html()->Input('amountPayable','amountPayable', 0, false, true),
                        $this->Html()->Input('amount_payable','amount_payable', 0, false, false, 'form-control', 'hidden'),
                    )
                )
            ),

        );

    }

    private function selectRole(){
        $output = [];
        $user = UserObject::instance();
        if($user->getRole() == "AdminRole"){
            $output[] = $this->Html()->FormGroupStart(4) .
                $this->Html()->Radio('stock_type', 'stock_type1', 1, false, false, 'stock_type')->Checked(true).
                HtmlTags::Label('انبار اصلی')->Class('mr-2').
                $this->Html()->FormGroupEnd().

                $this->Html()->FormGroupStart(4) .
                $this->Html()->Radio('stock_type', 'stock_type2', 2, false, false, 'stock_type').
                HtmlTags::Label('انبار نمایندگان')->Class('mr-2').
                $this->Html()->FormGroupEnd().

                $this->Html()->FormGroupStart(4) .
                $this->Html()->Radio('stock_type', 'stock_type3', 3, false, false, 'stock_type').
                HtmlTags::Label('انبار امانی')->Class('mr-2').
                $this->Html()->FormGroupEnd().
                HtmlTags::Div('.stockDiv.w-100')
                    ->Content(
                        $this->Html()->FormGroupStart(12) .
                        $this->Html()->Label('انتخاب نماینده') .
                        $this->Html()->Select('partner_id', 'partner_id', \model\Partners::toOption(), false, false, false, '.hide').
                        $this->Html()->Input('role_name', 'role_name', 'admin', false, true, '', 'hidden'),
                        $this->Html()->FormGroupEnd(),


                    );
        } elseif($user->getRole() == "PartnerRole"){
            $partner = \model\Partners::Db()->where("user_id", $user->getUserId())->get()->first();
            $partnerId = $partner['partner_id'];
            $output[] = $this->Html()->FormGroupStart(4) .

                $this->Html()->Radio('stock_type', 'stock_type2', 2, false, false, 'stock_type')->Checked(true).
                HtmlTags::Label('انبار '.$user->getName())->Class('mr-2').
                $this->Html()->FormGroupEnd().

                $this->Html()->FormGroupStart(4) .
                $this->Html()->Radio('stock_type', 'stock_type3', 3, false, false, 'stock_type').
                HtmlTags::Label('انبار امانی')->Class('mr-2').
                $this->Html()->FormGroupEnd().
                $this->Html()->Input('role_name', 'role_name', 'partner', false, true, '', 'hidden').
                $this->Html()->Input('partner_id', 'partner_id', $partnerId, false, false, '', 'hidden');

        }

        return implode("",$output);
    }

}
        