<?php

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\FontAwesome;
use View;

class Customers extends View
{

    public $SingularName = 'مشتری';
    public $PluralName = 'مشتریان';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('نام مشتری'),
                                                                    HtmlTags::Th('شماره موبایل'),
                                                                    HtmlTags::Th('سطح عضویت'),
                                                                    HtmlTags::Th('موجودی کیف پول'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('200'),
                                                                    HtmlTags::Th('.no-sort فعالسازی')->Width('50')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'customer_id' => function ($item) {
                                                                        $name = \model\Customers::get($item);
                                                                        return $name->customer_first_name . ' ' . $name->customer_last_name;
                                                                    },
                                                                    'customer_mobile',
                                                                    'customer_level_id'=>function($item){
                                                                        return \model\Levels::get($item)->level_name;
                                                                    },
                                                                    'customer_credit' => function($item) {
                                                                        return number_format($item).' تومان';
                                                                    },
                                                                ], false, true, true, true, function ($value) {

                                                                    return HtmlTags::Button('.btn.btn-outline-success.m-2.p-2.m-1.updateCredit')->Content(
                                                                        HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Money())
                                                                    )->Data_('id', $value->customer_id)->Data_('toggle', 'tooltip')
                                                                        ->Data_('placement', 'top')
                                                                        ->Title('موجودی کیف پول');

                                                                })
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                ). $this->buildUpdateCreditModal();
    }

    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }

    public function Form()
    {
        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('نام') .
                                        $this->Html()->Input('customer_first_name', 'customer_first_name') .
                                        $this->Html()->FormGroupEnd(),

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('نام خانوادگی') .
                                        $this->Html()->Input('customer_last_name', 'customer_last_name') .
                                        $this->Html()->FormGroupEnd(),

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('موبایل') .
                                        $this->Html()->Mobile('customer_mobile','customer_mobile') .
                                        $this->Html()->FormGroupEnd(),

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('جنسیت') .
                                        $this->Html()->Input('customer_gender','customer_gender') .
                                        $this->Html()->FormGroupEnd(),

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('رمز عبور') .
                                        $this->Html()->Password('customer_password') .
                                        $this->Html()->FormGroupEnd(),

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('تصویر پروفایل(اختیاری)') .
                                        $this->Html()->ImageInput('customer_avatar','',350,350,'','customer_avatar',false) .
                                        $this->Html()->FormGroupEnd(),

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('سطح عضویت') .
                                        $this->Html()->Select('customer_level_id','customer_level_id',\model\Levels::toOption()) .
                                        $this->Html()->FormGroupEnd(),

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('موجودی اولیه کیف پول') .
                                        $this->Html()->Price('customer_credit','customer_credit') .
                                        $this->Html()->FormGroupEnd(),

                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }

    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    private function buildUpdateCreditModal()
    {
        return HtmlTags::Div(".modal.fade#updateCreditModal")->Content(
            HtmlTags::Div('.modal-dialog.modal-lg')->Content(
                HtmlTags::Div('.modal-content')->Content(
                    HtmlTags::Div('.modal-header')->Content(
                        HtmlTags::H4('.modal-title')->Content(
                            "ویرایش موجودی کیف پول"
                        ),
                        HtmlTags::Div('.pull-left')->Content(
                            HtmlTags::Button('.close')->Content('&times;')->Data_('dismiss', 'modal')->Type('button')
                        )

                    ),
                    HtmlTags::Div('.modal-body')->Content(
                        HtmlTags::Div('.row')
                            ->Content(
                                HtmlTags::Div('.col-md-12')->Content(
                                    HtmlTags::Div('.card.card-primary.card-outline')
                                        ->Content(
                                            $this->Html()->FormStart().

                                            $this->Html()->Input('customerId')->Attrs(['type' => 'hidden']) .

                                            $this->Html()->FormGroupStart(6) .
                                            $this->Html()->Label('موجودی فعلی کیف پول') .
                                            $this->Html()->Price('current_credit', 'current_credit', 'تومان', '', false, true) .
                                            $this->Html()->FormGroupEnd() .

                                            $this->Html()->FormGroupStart(6) .
                                            $this->Html()->Label('مبلغ افزایش یا کاهش کیف پول') .
                                            $this->Html()->Price('new_credit') .
                                            $this->Html()->FormGroupEnd() .



                                            $this->Html()->CardFooter()
                                        )
                                )
                            )
                    ),
                    HtmlTags::Div('.modal-footer.d-flex.flex-wrap.space-between')->Content(
                        HtmlTags::Button('.btn.btn-outline-danger.p-2')->Content(
                            "انصراف"
                        )->Attrs(['type' => 'button'])->Data_('dismiss', 'modal'),
                        HtmlTags::Button('.btn.btn-success.p-2.mr-auto.ml-0.confirmChange')->Content(
                            "افزایش"
                        )->Data_('id', 'add'),
                        HtmlTags::Button('.btn.btn-danger.p-2.mr-auto.ml-0.confirmChange')->Content(
                            "کاهش"
                        )->Data_('id', 'sub')
                    )
                )
            )
        );
    }

}
