<?
namespace view;
use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;
class Partners extends View
{

    public $SingularName = 'نماینده';
    public $PluralName = 'نمایندگان';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('نام نماینده'),
                                                                    HtmlTags::Th('نام فروشگاه'),
                                                                    HtmlTags::Th('استان'),
                                                                    HtmlTags::Th('شهر'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('200'),
                                                                    HtmlTags::Th('.no-sort فعال سازی')->Width('50')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'partner_id'=>function($item){
                                                                    $a= \model\Partners::get($item);
                                                                    return $a->first_name.' '.$a->last_name.' - '.$a->mobile;
                                                                },
                                                                    'shop_name',
                                                                    'state_id'=>function($item){
                                                                        return \model\States::get($item)->state_name;
                                                                    },
                                                                    'city_id'=>function($item){
                                                                        return \model\Cities::get($item)->city_name;
                                                                    },],true, true, true, true)
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }
    
    public function Form()
    {
        return $this->Html()->BreadCrumbs() .HtmlTags::Section('.content')
    ->Content(
        HtmlTags::Div('.row')
            ->Content(
                HtmlTags::Div('.col-md-12')->Content(
                    HtmlTags::Div('.card.card-primary.card-outline')
                        ->Content(
                            HtmlTags::Div('.card-header')
                                ->Content(
                                    $this->Html()->CardTitle(),
                                    $this->Html()->refreshAndBack()
                                ),
                                    $this->Html()->FormStart().
                                      $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('نام') .
                            $this->Html()->Input('first_name') .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('نام خانوادگی') .
                            $this->Html()->Input('last_name') .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('نام فروشگاه') .
                            $this->Html()->Input('shop_name') .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('تلفن همراه') .
                            $this->Html()->Mobile('mobile') .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('کد ملی') .
                            $this->Html()->NationalCode('national_code') .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('تلفن فروشگاه') .
                            $this->Html()->NumberInput('tel') .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('کلمه عبور') .
                            $this->Html()->Password('password') .
                            $this->Html()->FormGroupEnd() .

                                    $this->Html()->FormGroupStart(4).
                                    $this->Html()->Label('انتخاب استان').
                                    $this->Html()->Select('state_id','state_id',\model\States::toOption()).
                                    $this->Html()->FormGroupEnd().

                                    $this->Html()->FormGroupStart(4).
                                    $this->Html()->Label('انتخاب شهر').
                                    $this->Html()->Select('city_id','city_id',\model\Cities::toOption()).
                                    $this->Html()->FormGroupEnd().

                                    $this->Html()->FormGroupStart(4).
                                    $this->Html()->Label('انتخاب منطقه').
                                    $this->Html()->Select('district_id','district_id',\model\Districts::toOption()).
                                    $this->Html()->FormGroupEnd().

                                    $this->Html()->FormGroupStart(8) .
                                    $this->Html()->Label('آدرس فروشگاه') .
                                    $this->Html()->Input('address') .
                                    $this->Html()->FormGroupEnd()  .

                                    $this->Html()->FormGroupStart(12).
                                    $this->Html()->Label('انتخاب آدرس روی نقشه').
                                    $this->MapMarker('address_latitude','address_longitude').
                                    $this->Html()->FormGroupEnd().


                                    $this->Html()->CardFooter()
                        )
                )
            )
    );
    }
    
    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }
    
    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }
    
    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }
    
    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
        