<?
namespace view;
use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Entity\ProductValuesEntity;
use View;
class ProductInformationValues extends View
{

    public $SingularName = 'مقدار مشخصات فنی';
    public $PluralName = 'مقادیر مشخصات فنی';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('نوع مشخصات'),
                                                                    HtmlTags::Th('مقدار مشخصات'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'product_information_value'=>function($item){
                                                                    /** @var ProductInformationValues $info */
                                                                        $info = \model\ProductInformations::get($item);
                                                                        return $info->product_information_name;
                                                                    },
                                                                    'product_information_id'])
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }
    
    public function Form()
    {
        return $this->Html()->BreadCrumbs() .HtmlTags::Section('.content')
    ->Content(
        HtmlTags::Div('.row')
            ->Content(
                HtmlTags::Div('.col-md-12')->Content(
                    HtmlTags::Div('.card.card-primary.card-outline')
                        ->Content(
                            HtmlTags::Div('.card-header')
                                ->Content(
                                    $this->Html()->CardTitle(),
                                    $this->Html()->refreshAndBack()
                                ),
                                    $this->Html()->FormStart().
                                      $this->Html()->FormGroupStart(4) .
                                    $this->Html()->Label('انتخاب مشخصات') .
                            $this->Html()->Select('product_information_value', 'product_information_value',  \model\ProductInformations::toOption()) .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(4) .
                                    $this->Html()->Label('مقدار مشخصات') .
                            $this->Html()->Input('product_information_id') .
                            $this->Html()->FormGroupEnd()  .
                                    $this->Html()->CardFooter()
                        )
                )
            )
    );
    }
    
    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }
    
    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }
    
    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }
    
    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
        