<?php

namespace view;

use View;
use DOMWrap\Document;
use FwPagination\Views\ViewPagination;
use FwHtml\Elements\Tags\Main\HtmlTags;

class Products extends View
{
    use ViewPagination;
    public $SingularName = 'محصول';
    public $PluralName = 'محصولات';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        $this->wrap(HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('نام محصول'),
                                                                    HtmlTags::Th('تصویر'),
                                                                    HtmlTags::Th('تعداد'),
                                                                    HtmlTags::Th('قیمت'),
                                                                    HtmlTags::Th('دسته بندی'),
                                                                    HtmlTags::Th('زیر دسته بندی های'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'product_name',
                                                                    'showImage'=>'product_image',
                                                                    function($item){
                                                                        $id= $item['product_id'];
                                                                        $count = \model\MainStocks::Db()->custom("SELECT SUM(product_count) AS totalCount FROM  tblMainStocks WHERE product_id = {$id}")->get()->first;
                                                                        return $count->totalCount > 0 ? $count->totalCount : 0;
                                                                    },
                                                                    function($item){
                                                                        $id= $item['product_id'];
                                                                        $count = \model\MainStocks::Db()->custom("SELECT sell_price AS totalPrice FROM  tblMainStocks WHERE product_id = {$id}")->get()->first;
                                                                        return en_to_fa(($count->totalPrice > 0 ? number_format($count->totalPrice) : 0). ' تومان');
                                                                    },
                                                                    'cat_id' => function ($item) {
                                                                        return \model\Categories::get($item)->category_name;
                                                                    },
                                                                    'sub_cats'=>function($item){
                                                                    $decode = json_decode($item);
                                                                    if ($decode){
                                                                        $output=[];
                                                                        foreach ($decode as $value){
                                                                            $output[]=\model\Categories::get($value)->category_name;
                                                                        }
                                                                        return implode(' / ',$output);
                                                                    }else{
                                                                        return'زیر دسته بندی ها یافت نشدند';
                                                                    }

                                                                    }
                                                                ])
                                                            )
                                                    )
                                            ),9, ['product_name']
                                        )
                                    )
                            )
                        )
                );
    }

    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }

    public function Form()
    {
        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .

                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('اطلاعات پایه') .

                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('دسته بندی اصلی محصول') .
                                        $this->Html()->Select('cat_id','cat_id',selectByClass(new \model\Categories(),'category_name','category_id',true,'','parent_id = 0'),false,true,false,'cat_id category') .
                                        $this->Html()->FormGroupEnd(),

                                        $this->Html()->FormGroupStart(6) .
                                        HtmlTags::Div('.subCats')->Content('') .
                                        $this->Html()->FormGroupEnd(),

                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('اطلاعات محصول') .

                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('نام محصول') .
                                        $this->Html()->Input('product_name','product_name') .
                                        $this->Html()->FormGroupEnd(),

//                                        $this->Html()->FormGroupStart(3) .
//                                        $this->Html()->Label('قیمت محصول') .
//                                        $this->Html()->Price('product_price','product_price','تومان') .
//                                        $this->Html()->FormGroupEnd(),
//
//                                        $this->Html()->FormGroupStart(3) .
//                                        $this->Html()->Label('تعداد محصول') .
//                                        $this->Html()->Input('product_amount', 'product_amount') .
//                                        $this->Html()->FormGroupEnd(),

                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('تصویر محصول') .
                                        $this->Html()->ImageInput('product_image') .
                                        $this->Html()->FormGroupEnd(),

                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('برند محصول') .
                                        $this->Html()->Select('brand_id','brand_id',\model\Brands::toOption()) .
                                        $this->Html()->FormGroupEnd(),

                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('برچسب های محصول') .
                                        $this->Html()->Select('tag_ids[]','tag_ids',\model\Tags::toOption(),true) .
                                        $this->Html()->FormGroupEnd(),



                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('توضیحات کوتاه') .
                                        $this->Html()->TextArea('product_brief','product_brief') .
                                        $this->Html()->FormGroupEnd(),

                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('توضیحات کامل') .
                                        $this->Html()->TextArea('product_details','product_details') .
                                        $this->Html()->FormGroupEnd(),

                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('مشخصات فنی محصول') .

                                       $this->ProductInformation().

                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }

    private function ProductInformation(){
        return HtmlTags::Table('.table')->Content(
            HtmlTags::Thead('.thead-dark')->Content(
                HtmlTags::Tr()->Content(
                    HtmlTags::Th()->Content(
                        '#'
                    ),
                    HtmlTags::Th()->Content(
                        'ویژگی محصول'
                    ),
                    HtmlTags::Th()->Content(
                        'مقادیر'
                    )
                )
            ),
            HtmlTags::Tbody("#tableBody")->Content()
        );
    }

    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
