<?php
namespace view;
use FwAuthSystem\Main\UserObject;
use FwBase\Reports\ReportView;
use FwHtml\Elements\Attrs\Style;
use FwHtml\Elements\Tags\Html;
use FwHtml\Elements\Tags\Main\HtmlTags;


class InvoiceBackReports extends ReportView {
    public $SingularName = 'فاکتور برگشت از فروش';
    public $PluralName = 'فاکتورهای برگشت از فروش';

    public function ReportFields(): array {
        $paymentData = '<option value="1">نقدی</option><option value="2">پرداخت آنلاین</option><option value="3">واریز به حساب</option><option value="4">اعتباری</option><option value="5">اقساطی</option>';
        $stockType = '<option value="1">انبار اصلی</option><option value="2">انبار نمایندگان</option><option value="3">انبار امانی</option>';
        return  [

            $this->SimpleSelect('customer_id','مشتری',\model\Customers::toOption(false),4),
            $this->SimpleSelect('payment_type','نحوه پرداخت',$paymentData,4),
            $this->SimpleSelect('stock_type','انتخاب انبار',$stockType,4),
            $this->DateFromTo("date",'تاریخ فاکتور '),

        ];
    }

    public function thList() {
        return HtmlTags::Tr()->Content(
            HtmlTags::Th('.no-sort')->Content("ردیف")->Style(new Style([Style\Props\Width::Em(7)])),
            HtmlTags::Th()->Content("نام مشتری")->Style(new Style([Style\Props\Width::Em(10)])),
            HtmlTags::Th()->Content("هزینه کل")->Style(new Style([Style\Props\Width::Em(10)])),
            HtmlTags::Th()->Content("وضعیت")->Style(new Style([Style\Props\Width::Em(10)])),
            HtmlTags::Th()->Content("تاریخ فاکتور")->Style(new Style([Style\Props\Width::Em(20)])),
            HtmlTags::Th()->Content("نحوه پرداخت")->Style(new Style([Style\Props\Width::Em(20)])),
            HtmlTags::Th()->Content("فروش از")->Style(new Style([Style\Props\Width::Em(20)])),
            HtmlTags::Th('.no-sort')->Content("جزئیات")->Style(new Style([Style\Props\Width::Em(15)]))
        );
    }

    public function makeRow($result)
    {

        return HtmlTags::Table('.table.table-bordered.table-striped')->Content(
            HtmlTags::Thead()->Content(
                $this->thList()
            ),
            HtmlTags::Tbody()->Content(
                function () use ($result){
                    $output = [];
                    foreach ($result as $item) {
                        $output[] = HtmlTags::Tr()->Content(
                            HtmlTags::Td(),
                            HtmlTags::Td()->Content($item['CustomerName']),
                            HtmlTags::Td()->Content($item['paymentPrice']),
                            HtmlTags::Td()->Content($item['orderStatus']),
                            HtmlTags::Td()->Content($item['orderDate']),
                            HtmlTags::Td()->Content($item['paymentType']),
                            HtmlTags::Td()->Content($item['stockType']),
                            HtmlTags::Td()->Content(HtmlTags::A('.btn.btn-outline-info.m-1.details')->Content(HtmlTags::I('.fa.fa-download'))->Data_('toggle', 'tooltip')->Title('جزئیات فاکتور')->Data_('id', $item['order_id']))
                        );

                    }
                    return implode('',$output);
                }
            ),
            HtmlTags::Tfoot()->Content(
                HtmlTags::Tr()->Content(
                    HtmlTags::Th()->Content(
                        ''
                    )->Attrs(['colspan'=>7]),
                    HtmlTags::Td()->Content(HtmlTags::A('.btn.btn-outline-info.m-1.export')->Content(HtmlTags::I('.fa.fa-download').' دانلود فایل اکسل')->Data_('toggle', 'tooltip')->Title('جزئیات فاکتور'))
                )

            )


        );
    }


}
