$(function () {
    $(document).off("click", ".export").on("click", ".export", function () {
        let product_id = $('#fw_report_product_id').find(":selected").val();
        let date_from = $('#fw_report_date_from').val();
        let date_to = $('#fw_report_date_to').val();
        $.ajax({
            url: "controllers/Reports/Financial/ProductFollowReports",
            type: "POST",
            data: {
                product_id, date_from, date_to,
                controller_type: "exportXls"
            }, success: function (data) {
                const element = document.createElement('a');
                const split = data.split('/');
                element.download = split[split.length - 1];
                element.href = data;
                element.target = "_blank";
                element.click();
            }
        })
    });

    $(document).off("click", ".details").on("click", ".details", function () {
        let orderId = $(this).data('id');

        $.ajax({
            url: "controllers/Reports/Financial/ProductFollowReports",
            type: "POST",
            data: {
                orderId,
                controller_type: "exportDetailXls"
            }, success: function (data) {
                const element = document.createElement('a');
                const split = data.split('/');
                element.download = split[split.length - 1];
                element.href = data;
                element.target = "_blank";
                element.click();
            }
        })
    });
})

Reports.init();
Reports.setUrl('controllers/Reports/Financial/ProductFollowReports')
