<?php
namespace view;
use FwAuthSystem\Main\UserObject;
use FwBase\Reports\ReportView;
use FwHtml\Elements\Attrs\Style;
use FwHtml\Elements\Tags\Html;
use FwHtml\Elements\Tags\Main\HtmlTags;


class ProductFollowReports extends ReportView {
    public $SingularName = 'گردش کالا';

    public function ReportFields(): array {
        return  [

            $this->SimpleSelect('product_id','انتخاب کالا',\model\Products::toOption(false),12, false),
            $this->DateFromTo("date",'تاریخ فاکتور '),

        ];
    }

    public function thList() {
        return HtmlTags::Tr()->Content(
            HtmlTags::Th('.no-sort')->Content("ردیف")->Style(new Style([Style\Props\Width::Em(7)])),
            HtmlTags::Th()->Content("نوع برگه")->Style(new Style([Style\Props\Width::Em(10)])),
            HtmlTags::Th()->Content("شماره برگه")->Style(new Style([Style\Props\Width::Em(10)])),
            HtmlTags::Th()->Content("تاریخ برگه")->Style(new Style([Style\Props\Width::Em(10)])),
            HtmlTags::Th()->Content("انبار برگه")->Style(new Style([Style\Props\Width::Em(10)])),
            HtmlTags::Th()->Content("توضیحات برگه")->Style(new Style([Style\Props\Width::Em(20)])),
            HtmlTags::Th()->Content("حساب مقابل برگه")->Style(new Style([Style\Props\Width::Em(20)])),
            HtmlTags::Th('.no-sort')->Content("جزئیات")->Style(new Style([Style\Props\Width::Em(15)]))
        );
    }

    public function makeRow($result)
    {

        return HtmlTags::Table('.table.table-bordered.table-striped')->Content(
            HtmlTags::Thead()->Content(
                $this->thList()
            ),
            HtmlTags::Tbody()->Content(
                function () use ($result){
                    $output = [];
                    foreach ($result as $item) {
                        $output[] = HtmlTags::Tr()->Content(
                            HtmlTags::Td(),
                            HtmlTags::Td()->Content($item['report_type']),
                            HtmlTags::Td()->Content(''.$item['report_id']),
                            HtmlTags::Td()->Content($item['reportDate']),
                            HtmlTags::Td()->Content($item['reportStorage']),


                            HtmlTags::Td()->Content($item['description']),
                            HtmlTags::Td()->Content($item['againstAccount']),
                            HtmlTags::Td()->Content(HtmlTags::A('.btn.btn-outline-info.m-1.details')->Content(HtmlTags::I('.fa.fa-download'))->Data_('toggle', 'tooltip')->Title('جزئیات حواله')->Data_('id', $item['report_id']))
                        );

                    }
                    return implode('',$output);
                }
            ),
            HtmlTags::Tfoot()->Content(
                HtmlTags::Tr()->Content(
                    HtmlTags::Th()->Content(
                        ''
                    )->Attrs(['colspan'=>6]),
                    HtmlTags::Td()->Content(HtmlTags::A('.btn.btn-outline-info.m-1.export')->Content(HtmlTags::I('.fa.fa-download').' دانلود فایل اکسل')->Data_('toggle', 'tooltip')->Title('جزئیات فاکتور'))
                )

            )


        );
    }


}
