<?php
namespace view;
use FwAuthSystem\Main\UserObject;
use FwBase\Reports\ReportView;
use FwHtml\Elements\Attrs\Style;
use FwHtml\Elements\Tags\Html;
use FwHtml\Elements\Tags\Main\HtmlTags;


class ReciveReports extends ReportView {
    public $SingularName = 'رسید دریافت';
    public $PluralName = 'رسیدهای دریافت';

    public function ReportFields(): array {

        return  [

            $this->SimpleSelect('customer_id','مشتری',\model\Customers::toOption(false),12),
            $this->DateFromTo("date",'تاریخ فاکتور '),

        ];
    }

    public function thList() {
        return HtmlTags::Tr()->Content(
            HtmlTags::Th('.no-sort')->Content("ردیف")->Style(new Style([Style\Props\Width::Em(7)])),
            HtmlTags::Th()->Content("نوع رسید")->Style(new Style([Style\Props\Width::Em(10)])),
            HtmlTags::Th()->Content("شماره رسید")->Style(new Style([Style\Props\Width::Em(10)])),
            HtmlTags::Th()->Content("تاریخ رسید")->Style(new Style([Style\Props\Width::Em(20)])),
            HtmlTags::Th()->Content("طرف حساب")->Style(new Style([Style\Props\Width::Em(20)])),
            HtmlTags::Th()->Content("توضیحات")->Style(new Style([Style\Props\Width::Em(20)])),
            HtmlTags::Th('.no-sort')->Content("جزئیات")->Style(new Style([Style\Props\Width::Em(15)]))
        );
    }

    public function makeRow($result)
    {

        return HtmlTags::Table('.table.table-bordered.table-striped')->Content(
            HtmlTags::Thead()->Content(
                $this->thList()
            ),
            HtmlTags::Tbody()->Content(
                function () use ($result){
                    $output = [];
                    foreach ($result as $item) {
                        $output[] = HtmlTags::Tr()->Content(
                            HtmlTags::Td(),
                            HtmlTags::Td()->Content($item['ReceiveType']),
                            HtmlTags::Td()->Content(''.$item['order_id']),
                            HtmlTags::Td()->Content($item['ReceiveDate']),
                            HtmlTags::Td()->Content($item['CustomerName']),
                            HtmlTags::Td()->Content($item['Description']),
                            HtmlTags::Td()->Content(HtmlTags::A('.btn.btn-outline-info.m-1.details')->Content(HtmlTags::I('.fa.fa-download'))->Data_('toggle', 'tooltip')->Title('جزئیات فاکتور')->Data_('id', $item['order_id']))
                        );

                    }
                    return implode('',$output);
                }
            ),
            HtmlTags::Tfoot()->Content(
                HtmlTags::Tr()->Content(
                    HtmlTags::Th()->Content(
                        ''
                    )->Attrs(['colspan'=>6]),
                    HtmlTags::Td()->Content(HtmlTags::A('.btn.btn-outline-info.m-1.export')->Content(HtmlTags::I('.fa.fa-download').' دانلود فایل اکسل')->Data_('toggle', 'tooltip')->Title('جزئیات فاکتور'))
                )

            )


        );
    }


}
