$(function () {
    $(document).off("click", ".export").on("click", ".export", function () {
        let inputStock = $('#fw_report_inputStock').find(":selected").val();
        let outputStock = $('#fw_report_outputStock').find(":selected").val();
        let date_from = $('#fw_report_date_from').val();
        let date_to = $('#fw_report_date_to').val();
        $.ajax({
            url: "controllers/Reports/Financial/TransferReports",
            type: "POST",
            data: {
                inputStock, outputStock, date_from, date_to,
                controller_type: "exportXls"
            }, success: function (data) {
                const element = document.createElement('a');
                const split = data.split('/');
                element.download = split[split.length - 1];
                element.href = data;
                element.target = "_blank";
                element.click();
            }
        })
    });

    $(document).off("click", ".details").on("click", ".details", function () {
        let orderId = $(this).data('id');

        $.ajax({
            url: "controllers/Reports/Financial/TransferReports",
            type: "POST",
            data: {
                orderId,
                controller_type: "exportDetailXls"
            }, success: function (data) {
                const element = document.createElement('a');
                const split = data.split('/');
                element.download = split[split.length - 1];
                element.href = data;
                element.target = "_blank";
                element.click();
            }
        })
    });
})

Reports.init();
Reports.setUrl('controllers/Reports/Financial/TransferReports')
