<?php
namespace view;
use FwAuthSystem\Main\UserObject;
use FwBase\Reports\ReportView;
use FwHtml\Elements\Attrs\Style;
use FwHtml\Elements\Tags\Html;
use FwHtml\Elements\Tags\Main\HtmlTags;


class TransferReports extends ReportView {
    public $SingularName = 'انتقال بین انبار';

    public function ReportFields(): array {
        $inputStock = '<option value="0">انبار اصلی</option><option value="1">انبار نمایندگان</option><option value="2">انبار امانی</option><option value="3">انبار ضایعات</option>';
        $outputStock = '<option value="0">انبار اصلی</option><option value="1">انبار نمایندگان</option><option value="2">انبار امانی</option><option value="3">انبار ضایعات</option>';
        return  [

            $this->SimpleSelect('inputStock','انبار مبدا',$inputStock,6),
            $this->SimpleSelect('outputStock','انبار مقصد',$outputStock,6),
            $this->DateFromTo("date",'تاریخ فاکتور '),

        ];
    }

    public function thList() {
        return HtmlTags::Tr()->Content(
            HtmlTags::Th('.no-sort')->Content("ردیف")->Style(new Style([Style\Props\Width::Em(7)])),
            HtmlTags::Th()->Content("شماره برگه")->Style(new Style([Style\Props\Width::Em(10)])),
            HtmlTags::Th()->Content("تاریخ برگه")->Style(new Style([Style\Props\Width::Em(10)])),
            HtmlTags::Th()->Content("انبار مبدا")->Style(new Style([Style\Props\Width::Em(10)])),
            HtmlTags::Th()->Content("انبار مقصد")->Style(new Style([Style\Props\Width::Em(20)])),
            HtmlTags::Th()->Content("توضیحات")->Style(new Style([Style\Props\Width::Em(20)])),
            HtmlTags::Th('.no-sort')->Content("جزئیات")->Style(new Style([Style\Props\Width::Em(15)]))
        );
    }

    public function makeRow($result)
    {

        return HtmlTags::Table('.table.table-bordered.table-striped')->Content(
            HtmlTags::Thead()->Content(
                $this->thList()
            ),
            HtmlTags::Tbody()->Content(
                function () use ($result){
                    $output = [];
                    foreach ($result as $item) {
                        $output[] = HtmlTags::Tr()->Content(
                            HtmlTags::Td(),
                            HtmlTags::Td()->Content(''.$item['report_id']),
                            HtmlTags::Td()->Content($item['reportDate']),
                            HtmlTags::Td()->Content($item['inputStorage']),
                            HtmlTags::Td()->Content($item['outputStorage']),
                            HtmlTags::Td()->Content($item['description']),
                            HtmlTags::Td()->Content(HtmlTags::A('.btn.btn-outline-info.m-1.details')->Content(HtmlTags::I('.fa.fa-download'))->Data_('toggle', 'tooltip')->Title('جزئیات حواله')->Data_('id', $item['report_id']))
                        );

                    }
                    return implode('',$output);
                }
            ),
            HtmlTags::Tfoot()->Content(
                HtmlTags::Tr()->Content(
                    HtmlTags::Th()->Content(
                        ''
                    )->Attrs(['colspan'=>6]),
                    HtmlTags::Td()->Content(HtmlTags::A('.btn.btn-outline-info.m-1.export')->Content(HtmlTags::I('.fa.fa-download').' دانلود فایل اکسل')->Data_('toggle', 'tooltip')->Title('جزئیات فاکتور'))
                )

            )


        );
    }


}
