<?
namespace view;
use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;

class DepositeStocks extends View
{

    public $SingularName = 'کالا به انبار امانی';
    public $PluralName = 'کالاهای انبار امانی';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('نام نماینده'),
                                                                    HtmlTags::Th('نام کالا'),
                                                                    HtmlTags::Th('کد فنی'),
                                                                    HtmlTags::Th('تعداد کالا'),
                                                                    HtmlTags::Th('قیمت فروش'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'partner_id'=>function($item){
                                                                        return \model\Partners::get($item)->shop_name;
                                                                    },
                                                                    'product_id'=>function($item){
                                                                        return \model\Products::get($item)->product_name;
                                                                    },
                                                                    'deposite_stock_id'=>function($item){
                                                                        $productId = \model\DepositeStocks::get($item)->product_id;
                                                                        return \model\MainStocks::getOneFiltered('product_id',$productId)->peyvast_code;
                                                                    },
                                                                    'product_count',
                                                                    'buy_price'
                                                                ])
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }
    
    public function Form()
    {
        $productData = '<option value="" selected disabled>لطفا یک کالا را انتخاب کنید</option>';
        $products = \model\MainStocks::getAllConditioned('product_count > 0');
        foreach ($products as $product){
            $data = \model\Products::get($product->product_id);
            $productData .= '<option value="'.$data->product_id.'">'.$data->product_name.' --- موجودی در انبار اصلی:  '. $product->product_count.  ' عدد</option>';

        }
        return $this->Html()->BreadCrumbs() .HtmlTags::Section('.content')
    ->Content(
        HtmlTags::Div('.row')
            ->Content(
                HtmlTags::Div('.col-md-12')->Content(
                    HtmlTags::Div('.card.card-primary.card-outline')
                        ->Content(
                            HtmlTags::Div('.card-header')
                                ->Content(
                                    $this->Html()->CardTitle(),
                                    $this->Html()->refreshAndBack()
                                ),
                                    $this->Html()->FormStart().
                                      $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('انتخاب نماینده') .
                            $this->Html()->Select('partner_id', 'partner_id',  \model\Partners::toOption()) .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(8) .
                            $this->Html()->Label('انتخاب کالا') .
                            $this->Html()->Select('product_id', 'product_id',  $productData) .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('تعداد کالا') .
                            $this->Html()->Input('product_count', 'product_count', '', true, false, 'form-control', 'number') .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('کد پیوست') .
                            $this->Html()->Input('peyvast_code') .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('قیمت فروش') .
                            $this->Html()->Input('buy_price') .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('قیمت نماینده') .
                            $this->Html()->Input('partner_price') .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('مدت تسویه') .
                            $this->Html()->Input('settle_time') .
                            $this->Html()->FormGroupEnd()  .
                                    $this->Html()->CardFooter()
                        )
                )
            )
    );
    }
    
    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }
    
    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }
    
    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }
    
    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
        