import {Pagination} from "../../../modules/Pagination/Pagination";
Pagination.currentPath = CurrentPathForController;
Pagination.paginate();

$(function (){
    $('#progress-wrp').hide();
    let Upload = function (file) {
        this.file = file;
    };

    Upload.prototype.getType = function() {
        return this.file.type;
    };
    Upload.prototype.getSize = function() {
        return this.file.size;
    };
    Upload.prototype.getName = function() {
        return this.file.name;
    };
    Upload.prototype.doUpload = function (id) {
        let that = this;
        let formData = new FormData();

        // add assoc key values, this will be posts values
        formData.append("file", this.file, this.getName());
        formData.append("upload_file", true);

        $.ajax({
            type: "POST",
            url: "controllers/Stocks/MainStocks/MainStocks?stockId=" + id,
            xhr: function () {
                let myXhr = $.ajaxSettings.xhr();
                if (myXhr.upload) {
                    myXhr.upload.addEventListener('progress', that.progressHandling, false);
                }
                return myXhr;
            },
            success: function (data) {
                // your callback here
            },
            error: function (error) {
                // handle error
            },
            async: true,
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            timeout: 60000
        });
    };

    Upload.prototype.progressHandling = function (event) {
        let percent = 0;
        let position = event.loaded || event.position;
        let total = event.total;
        let progress_bar_id = "#progress-wrp";
        if (event.lengthComputable) {
            percent = Math.ceil(position / total * 100);
        }
        // update progressbars classes so it fits your code
        $(progress_bar_id + " .progress-bar").css("width", +percent + "%");
        $(progress_bar_id + " .status").text(percent + "%");
    };


    $(document).off("click", ".uploadBtn").on("click", ".uploadBtn", function () {
        let stockId = $(this).data('stockId');
        let xlsxFile = $('xlsxFile').files[0];
        let upload = new Upload(xlsxFile);
        $('#progress-wrp').show();
        upload.doUpload(stockId)



    })


})