<?
namespace view;
use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;
use FwPagination\Views\ViewPagination;
class MainStocks extends View
{
    use ViewPagination;
    public $SingularName = 'کالا به انبار اصلی';
    public $PluralName = 'کالاها در انبار اصلی';

    public function main(Document &$document)
    {

        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndAdd(),
                                                $this->Html()->uploadBtn()
                                            ),
                                        $this->wrap(HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('نام کالا'),
                                                                    HtmlTags::Th('تعداد'),
                                                                    HtmlTags::Th('کد فنی'),
                                                                    HtmlTags::Th('قیمت فروش'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'product_id'=>function($item){
                                                                        return \model\Products::get($item)->product_name;
                                                                    },
                                                                    'product_count',
                                                                    'peyvast_code',
                                                                    'price_format'=>'sell_price'
                                                                ])
                                                            )
                                                    )
                                            ),10, ['peyvast_code'])
                                    )
                            )
                        )
                );
    }
    
    public function Form()
    {
        return $this->Html()->BreadCrumbs() .HtmlTags::Section('.content')
    ->Content(
        HtmlTags::Div('.row')
            ->Content(
                HtmlTags::Div('.col-md-12')->Content(
                    HtmlTags::Div('.card.card-primary.card-outline')
                        ->Content(
                            HtmlTags::Div('.card-header')
                                ->Content(
                                    $this->Html()->CardTitle(),
                                    $this->Html()->refreshAndBack()
                                ),
                                    $this->Html()->FormStart().
                                      $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('انتخاب کالا') .
                            $this->Html()->Select('product_id', 'product_id',  \model\Products::toOption()) .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('تعداد') .
                            $this->Html()->Number('product_count','product_count') .
                            $this->Html()->FormGroupEnd() .

                                    $this->Html()->FormGroupStart(4) .
                                    $this->Html()->Label('کد فنی') .
                                    $this->Html()->Input('peyvast_code', 'peyvast_code') .
                                    $this->Html()->FormGroupEnd()  .



                                    $this->Html()->FormGroupStart(4) .
                                    $this->Html()->Label('قیمت فروش') .
                                    $this->Html()->Price('sell_price', 'sell_price') .
                                    $this->Html()->FormGroupEnd()  .
                                    $this->Html()->CardFooter()
                        )
                )
            )
    );
    }

    public function upload(Document &$document)
    {
        $document->html =  $this->Html()->BreadCrumbs() .HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndBack()
                                            ),

                                        $this->Html()->FormStart('importFile').
                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('انتخاب فایل') .
                                        $this->Html()->Input('xlsxFile')->Id('xlsxFile')->Type('file')->Attrs(['accept' => '.csv, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, application/vnd.ms-excel']) .
                                        $this->Html()->FormGroupEnd(),

                                        $this->Html()->Input('stockId')->Id('stockId')->Type('hidden')->Value('2'),
                                        $this->Html()->CardFooter()


                                    )
                            )
                        )
                );
    }

    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }
    
    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }
    
    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }
    
    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
        