<?
namespace view;
use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;
use FwPagination\Views\ViewPagination;
class PartnerStocksReports extends View
{
    use ViewPagination;
    public $SingularName = 'حواله های انبار نمایندگان';
    public $PluralName = 'حواله های انبار نمایندگان';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                            ),
                                        $this->wrap(HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('شماره حواله'),
                                                                    HtmlTags::Th('نام کالا'),
                                                                    HtmlTags::Th('کد کالا'),
                                                                    HtmlTags::Th('انبار نماینده'),
                                                                    HtmlTags::Th('تعداد حواله'),
                                                                    HtmlTags::Th('تعداد موجود'),
                                                                    HtmlTags::Th('قیمت نماینده'),
                                                                    HtmlTags::Th('قیمت فروش'),
                                                                    HtmlTags::Th('تاریخ حواله'),
                                                                    HtmlTags::Th('توضیحات'),
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'partner_stock_id',
                                                                    'product_id' => function($product_id) {
                                                                        return \model\Products::get($product_id)->product_name;
                                                                    },
                                                                    function($item) {
                                                                        $id= $item['partner_stocks_report_id'];
                                                                        $product_id = \model\PartnerStocksReports::get($id)->product_id;
                                                                        return \model\mainStockReports::getOneFiltered('product_id',$product_id)->peyvast_code;
                                                                    },
                                                                    'partner_id' => function($partner_id) {
                                                                        return \model\Partners::get($partner_id)->shop_name;
                                                                    },
                                                                    'product_count_next' => function($item){
                                                                        return abs($item);
                                                                    },
                                                                    function($item){
                                                                        $id= $item['partner_stocks_report_id'];
                                                                        $count = \model\PartnerStocks::Db()->custom("SELECT SUM(product_count) AS totalCount FROM  tblPartnerStocks WHERE partner_stock_id = {$id}")->get()->first;
                                                                        return $count->totalCount > 0 ? $count->totalCount : 0;
                                                                    },
                                                                    'partner_price_next' => function($item){
                                                                        return $item >0 ? number_format($item).' تومان' : '<a class="badge badge-danger p-2 text-white">ثبت نشده</a>';
                                                                    },
                                                                    'buy_price_next' => function($item){
                                                                        return $item >0 ? number_format($item).' تومان' : '<a class="badge badge-danger p-2 text-white">ثبت نشده</a>';
                                                                    },

                                                                    'log_date' => function($date){
                                                                        return jdate('Y/m/d <br/> H:i',($date));
                                                                    },
                                                                    'description',
                                                                ],false, false)
                                                            )
                                                    )
                                            ),10, ['peyvast_code'], 'جستجوی کد فنی...')
                                    )
                            )
                        )
                );
    }
    
    public function Form()
    {
        return $this->Html()->BreadCrumbs() .HtmlTags::Section('.content')
    ->Content(
        HtmlTags::Div('.row')
            ->Content(
                HtmlTags::Div('.col-md-12')->Content(
                    HtmlTags::Div('.card.card-primary.card-outline')
                        ->Content(
                            HtmlTags::Div('.card-header')
                                ->Content(
                                    $this->Html()->CardTitle(),
                                    $this->Html()->refreshAndBack()
                                ),
                                    $this->Html()->FormStart().
                                      $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('کد در انبار نماینده') .
                            $this->Html()->Input('partner_stock_id') .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('نام نماینده') .
                            $this->Html()->Input('partner_id') .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('نام کالا') .
                            $this->Html()->Input('product_id') .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('تعداد قبل از ثبت') .
                            $this->Html()->Input('product_count_before') .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('تعداد بعد از ثبت') .
                            $this->Html()->Input('product_count_next') .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('قیمت فروش قبل از ثبت') .
                            $this->Html()->Input('buy_price_before') .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('قیمت فروش بعد از ثبت') .
                            $this->Html()->Input('buy_price_next') .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('قیمت نماینده قبل از ثبت') .
                            $this->Html()->Input('partner_price_before') .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('قیمت نماینده بعد از ثبت') .
                            $this->Html()->Input('partner_price_next') .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('تاریخ ثبت') .
                            $this->Html()->Input('log_date') .
                            $this->Html()->FormGroupEnd()  .
                                    $this->Html()->CardFooter()
                        )
                )
            )
    );
    }
    
    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }
    
    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }
    
    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }
    
    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
        