<?
namespace view;
use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Entity\mainStockReportsEntity;
use model\Entity\MainStocksEntity;
use View;
use FwPagination\Views\ViewPagination;
class mainStockReports extends View
{
    use ViewPagination;
    public $SingularName = 'حواله های انبار اصلی';
    public $PluralName = 'حواله های انبار اصلی';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                            ),
                                        $this->wrap(HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('نام کالا'),
                                                                    HtmlTags::Th('کد فنی'),
                                                                    HtmlTags::Th('تعداد حواله'),
                                                                    HtmlTags::Th('تعداد موجود'),
                                                                    HtmlTags::Th('قیمت فروش'),
                                                                    HtmlTags::Th('تاریخ حواله'),
                                                                    HtmlTags::Th('تحویل گیرنده'),
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'product_id' => function($product_id) {
                                                                        return \model\Products::get($product_id)->product_name;
                                                                    },
                                                                    'peyvast_code',
                                                                    'product_count' => function($item){
                                                                        return abs($item);
                                                                    },
                                                                    'main_stock_id' => function($id){
                                                                        $count = \model\MainStocks::Db()->custom("SELECT SUM(product_count) AS totalCount FROM tblMainStocks WHERE main_stock_id = {$id}")->get()->first;
                                                                        return $count->totalCount;
                                                                    },
                                                                    'sell_price_after' => function($item){
                                                                        return $item >0 ? number_format($item).' تومان' : '<a class="badge badge-danger p-2 text-white">ثبت نشده</a>';
                                                                    },
                                                                    'log_date' => function($date){
                                                                        return jdate('Y/m/d <br/> H:i',($date));
                                                                    },
                                                                    'main_stock_report_id' => function($id){
                                                                    /** @var mainStockReportsEntity $data */
                                                                        $data = \model\mainStockReports::get($id);
                                                                        if($data->order_id !=0){
                                                                            $title = "فاکتور شماره ".$data->order_id;
                                                                            if($data->customer_id >0){
                                                                                $customer = \model\Customers::get($data->customer_id);
                                                                                $title.= '<br/>'.$customer->customer_first_name.' '.$customer->customer_last_name;
                                                                            }
                                                                        } elseif ($data->stock_type >0){
                                                                            $title = "انبار امانی";
                                                                            if($data->stock_id >0){
                                                                                $partner = \model\Partners::get($data->stock_id);
                                                                                $title.= '<br/>'.$partner->shop_name;
                                                                            }
                                                                        } else {
                                                                            $title = "------";
                                                                        }
                                                                        return $title;
                                                                    }],false, false)
                                                            )
                                                    )
                                            ),10, ['peyvast_code'], 'جستجوی کد فنی...')
                                    )
                            )
                        )
                );
    }
    
    public function Form()
    {
        return $this->Html()->BreadCrumbs() .HtmlTags::Section('.content')
    ->Content(
        HtmlTags::Div('.row')
            ->Content(
                HtmlTags::Div('.col-md-12')->Content(
                    HtmlTags::Div('.card.card-primary.card-outline')
                        ->Content(
                            HtmlTags::Div('.card-header')
                                ->Content(
                                    $this->Html()->CardTitle(),
                                    $this->Html()->refreshAndBack()
                                ),
                                    $this->Html()->FormStart().
                                      $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('کد انبار') .
                            $this->Html()->Input('main_stock_id') .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('نام کالا') .
                            $this->Html()->Input('product_id') .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('تعداد') .
                            $this->Html()->Input('product_count') .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('کد فنی') .
                            $this->Html()->Input('peyvast_code') .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('قیمت خرید') .
                            $this->Html()->Input('buy_price') .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('قیمت فروش') .
                            $this->Html()->Input('sell_price') .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('تاریخ ثبت') .
                            $this->Html()->Input('log_date') .
                            $this->Html()->FormGroupEnd()  .
                                    $this->Html()->CardFooter()
                        )
                )
            )
    );
    }
    
    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }
    
    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }
    
    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }
    
    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
        