<?php
namespace view;
use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;
class Tickets extends View
{

    public $SingularName = 'تیکت';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refresh()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('مشتری'),
                                                                    HtmlTags::Th('تیکت'),
                                                                    HtmlTags::Th('پاسخ'),
                                                                    HtmlTags::Th('عملیات'),
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'ticket_id'=>function($item){
                                                                    $ticket =\model\Tickets::get($item);
                                                                    if ($ticket->customer_id != 0){
                                                                        $a = \model\Customers::get($ticket->customer_id);
                                                                        return $a->customer_first_name.' '.$a->customer_last_name.' ('.$a->customer_mobile.')';
                                                                    }else{
                                                                        return $ticket->ticket_name." (".$ticket->ticket_email.')';
                                                                    }

                                                                    },
                                                                    'ticket_text',
                                                                    'ticket_answer'=>function($item){
                                                                    return $item?:HtmlTags::Span('.label.label-danger')->Content(
                                                                        'پاسخی ثبت نشده'
                                                                    );
                                                                    }
                                                                ],false,false,false,false,function ($item){
                                                                    return HtmlTags::Button('.btn.btn-outline-success.mx-1.answer')->Type('button')->Data_('toggle', 'tooltip')->Title("ارسال پاسخ")->Data_("ticket",$item->ticket_id)->Content(
                                                                        HtmlTags::I('.fa.fa-telegram')
                                                                    );
                                                                })
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }

    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }
    
    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }
    
    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }
    
    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
