<?php

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;
use Views\Html;

class UsersTable extends View
{

    public $SingularName = 'کاربر';
    public $PluralName = 'کاربران';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('نام کاربری'),
                                                                    HtmlTags::Th('نام کاربر'),
                                                                    HtmlTags::Th('نقش'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    "user_username",
                                                                    'user_name',
                                                                    'role_name' => function ($item) {
                                                                        switch ($item) {
                                                                            case 'AdminRole':
                                                                                return 'مدیر سیستم';
                                                                                break;
                                                                            case 'ContentRole':
                                                                                return "مدیر سایت";
                                                                                break;
                                                                            case 'CommerceRole':
                                                                                return "بازرگانی";
                                                                                break;
                                                                            case 'FinancialRole':
                                                                                return "مالی";
                                                                                break;
                                                                            default:
                                                                                return "نامشخص";
                                                                        }
                                                                    }
                                                                ])
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }

    public function Form()
    {

        $role =
            collect([
                HtmlTags::Option()->Selected()->Disabled()->Content('لطفا یک مورد را انتخاب کنید'),
                HtmlTags::Option()->Value('AdminRole')->Content('ادمین اصلی'),
                HtmlTags::Option()->Value('CommerceRole')->Content('بازرگانی'),
                HtmlTags::Option()->Value('FinancialRole')->Content('مالی'),
                HtmlTags::Option()->Value('ContentRole')->Content('مدیر سایت'),
            ])->join('');

        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .

                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('اطلاعات پایه') .

                                        $this->Html()->FormGroupStart().
                                        $this->Html()->Label('نام کاربری').
                                        $this->Html()->Input('user_username','user_username').
                                        $this->Html()->FormGroupEnd().

                                        $this->Html()->FormGroupStart().
                                        $this->Html()->Label('رمز عبور').
                                        $this->Html()->Password('user_password').
                                        $this->Html()->FormGroupEnd().

                                        $this->Html()->FormGroupStart().
                                        $this->Html()->Label('نام کاربر').
                                        $this->Html()->Input('user_name','user_name').
                                        $this->Html()->FormGroupEnd().

                                        $this->Html()->FormGroupStart().
                                        $this->Html()->Label('نقش کاربر').
                                        $this->Html()->Select('role_name','role_name',$role).
                                        $this->Html()->FormGroupEnd().

                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }

    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }

    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
