<?php
class Api
{

    public $api_url = 'https://pnl.nicepanel.site/api/v1';
    public $api_key = 'TxPV7eep1dLxdaNGfyC9LCtNgQd0GMgO';

    public $percent = 30;
    public function add_order($data)
    {
        $post = array_merge(array('key' => $this->api_key, 'action' => 'add'), $data);
        $result = $this->connect($post);
        return json_decode($result);
    }


    public function status($order_id)
    {
        $result = $this->connect(array(
            'key' => $this->api_key,
            'action' => 'status',
            'order' => $order_id
        ));
        return json_decode($result);
    }

    public function multi_status($order_ids)
    {
        $result = $this->connect(array(
            'key' => $this->api_key,
            'action' => 'status',
            'orders' => implode(",", (array)$order_ids)
        ));
        return json_decode($result);
    }

    public function services()
    {
        $result = $this->connect(array(
            'key' => $this->api_key,
            'action' => 'services',
        ));
        return json_decode($result);
    }

    public function balance()
    {
        $result = $this->connect(array(
            'key' => $this->api_key,
            'action' => 'balance',
        ));
        return json_decode($result);
    }

    private function connect($post)
    {
        $_post = array();

        if (is_array($post)) {
            foreach ($post as $name => $value) {
                $_post[] = $name . '=' . urlencode($value);
            }
        }

        if (is_array($post)) {
            $url_complete = join('&', $_post);
        }
        $url = $this->api_url . "?" . $url_complete;

        $ch = curl_init($url);

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_USERAGENT, 'API (compatible; MSIE 5.01; Windows NT 5.0)');
        $result = curl_exec($ch);
        if (curl_errno($ch) != 0 && empty($result)) {
            $result = false;
        }

        curl_close($ch);

        return $result;
    }
    public function instagram()
    {
        $result = array();
        $services = $this->services();
        foreach ($services as $service) {
            if (strpos($service->category, 'یوتیوب') === false
                and strpos($service->category, 'فیسبوک') === false
                and strpos($service->category, 'تلگرام') === false
                and strpos($service->category, 'کانال') === false
                and strpos($service->category, 'ساندکلاود') === false
                and strpos($service->category, 'توییچ') === false
                and strpos($service->category, 'اسپاتیفای') === false
                and strpos($service->category, 'تویتتر') === false
                and strpos($service->category, 'تیک تاک') === false
                and strpos($service->category, 'تیک تاک') === false
                and strpos($service->category, 'رایگان') === false
            ) {
                $result[] = $service;
            }
        }
        return $result;
    }

    public function telegram()
    {
        $result = array();
        $services = $this->services();
        foreach ($services as $service) {
            if (strpos($service->category, 'تلگرام') !== false
                or strpos($service->category, 'کانال') !== false
            ) {
                $result[] = $service;
            }
        }
        return $result;
    }

    public function facebook()
    {
        $result = array();
        $services = $this->services();
        foreach ($services as $service) {
            if (strpos($service->category, 'فیسبوک') !== false
            ) {
                $result[] = $service;
            }
        }
        return $result;
    }

    public function spotify()
    {
        $result = array();
        $services = $this->services();
        foreach ($services as $service) {
            if (strpos($service->category, 'اسپاتیفای') !== false
            ) {
                $result[] = $service;
            }
        }
        return $result;
    }

    public function twitch()
    {
        $result = array();
        $services = $this->services();
        foreach ($services as $service) {
            if (strpos($service->category, 'توییچ') !== false or strpos($service->category, 'توئیچ') !== false
            ) {
                $result[] = $service;
            }
        }
        return $result;
    }

    public function tiktok()
    {
        $result = array();
        $services = $this->services();
        foreach ($services as $service) {
            if (strpos($service->category, 'تیک تاک') !== false or strpos($service->category, 'تیکتاک') !== false
            ) {
                $result[] = $service;
            }
        }
        return $result;
    }

    public function twitter()
    {
        $result = array();
        $services = $this->services();
        foreach ($services as $service) {
            if (strpos($service->category, 'توئیتر') !== false or strpos($service->category, 'تویتتر') !== false or strpos($service->category, 'توییتر') !== false
            ) {
                $result[] = $service;
            }
        }
        return $result;
    }

    public function youtube()
    {
        $result = array();
        $services = $this->services();
        foreach ($services as $service) {
            if (strpos($service->category, 'یوتوب') !== false or strpos($service->category, 'یوتیوب') !== false
            ) {
                $result[] = $service;
            }
        }
        return $result;
    }

    public function soundcloud()
    {
        $result = array();
        $services = $this->services();
        foreach ($services as $service) {
            if (strpos($service->category, 'ساندکلاود') !== false or strpos($service->category, 'ساندکلاد') !== false or strpos($service->category, 'ساند کلاود') !== false
            ) {
                $result[] = $service;
            }
        }
        return $result;
    }


    public function instagramCategories()
    {
        $instagram = $this->instagram();
        $result = array_map(function($instagram){ return $instagram->category; }, $instagram);
        $result = array_unique($result);
        return $result;
    }

    public function telegramCategories()
    {
        $telegram = $this->telegram();
        $result = array_map(function($telegram){ return $telegram->category; }, $telegram);
        $result = array_unique($result);
        return $result;
    }

    public function facebookCategories()
    {
        $facebook = $this->facebook();
        $result = array_map(function($facebook){ return $facebook->category; }, $facebook);
        $result = array_unique($result);
        return $result;
    }

    public function twitterCategories()
    {
        $twitter = $this->twitter();
        $result = array_map(function($twitter){ return $twitter->category; }, $twitter);
        $result = array_unique($result);
        return $result;
    }

    public function youtubeCategories()
    {
        $youtube = $this->youtube();
        $result = array_map(function($youtube){ return $youtube->category; }, $youtube);
        $result = array_unique($result);
        return $result;
    }

    public function soundcloudCategories()
    {
        $soundcloud = $this->soundcloud();
        $result = array_map(function($soundcloud){ return $soundcloud->category; }, $soundcloud);
        $result = array_unique($result);
        return $result;
    }

    public function twitchCategories()
    {
        $twitch = $this->twitch();
        $result = array_map(function($twitch){ return $twitch->category; }, $twitch);
        $result = array_unique($result);
        return $result;
    }

    public function spotifyCategories()
    {
        $spotify = $this->spotify();
        $result = array_map(function($spotify){ return $spotify->category; }, $spotify);
        $result = array_unique($result);
        return $result;
    }

    public function tiktokCategories()
    {
        $tiktok = $this->tiktok();
        $result = array_map(function($tiktok){ return $tiktok->category; }, $tiktok);
        $result = array_unique($result);
        return $result;
    }

    public function viewCategories($category)
    {
        $result = array();
        $services = $this->services();
        foreach ($services as $service) {
            if (strpos($service->category, $category) !== false ) {
                $result[] = $service;
            }
        }
        return $result;
    }

    public function getServiceInfo($serviceId)
    {
        $services = $this->services();
        foreach ($services as $service) {
            if ($service->service == $serviceId  ) {
                return $service;
            }

        }
        return false;

    }

    public function typeOfServices()
    {
        $service = $this->services();
        return array_unique(array_map(function($service){ return $service->type; }, $service));
    }
}

// Examples
//$api = new Api();
//$services = $api->typeOfServices();;
//foreach ($services as $service) {
//    echo "<p>" . $service . "</p>";
//}
//$instagram = $api->instagram();
//var_dump($instagram);
# return all services
//$services = $api->services();
//foreach ($services as $service) {
//    if (strpos($service->category, 'یوتیوب') !== false
//        and strpos($service->category, 'فیسبوک') === false
//        and strpos($service->category, 'تلگرام') === false
//        and strpos($service->category, 'ساندکلاود') === false
//        and strpos($service->category, 'توییچ') === false
//        and strpos($service->category, 'اسپاتیفای') === false
//        and strpos($service->category, 'تویتتر ') === false
//        and strpos($service->category, 'تیک تاک') === false
//        and strpos($service->category, 'تیک تاک') === false
//        and strpos($service->category, 'رایگان') === false
//    ) {
//        echo "<p>" . $service->category . "<br/>".
//                     $service->name . "<br/>" .
//                     $service->rate . "<br>" .
//                     $service->min . "<br>" .
//                     $service->max . "<br>" .
//                     $service->desc . "<br>" .
//                     $service->dripfeed . "</p>";
//        //var_dump($service);
//    }

//}
# return user balance
//$balance = $api->balance();
//var_dump($balance);
// add order
//$order = $api->order(array('service' => 1, 'link' => 'http://example.com/test', 'quantity' => 100)); # Default

//$order = $api->order(array('service' => 1, 'link' => 'http://example.com/test', 'comments' => "good pic\ngreat photo\n:)\n;)")); # Custom Comments

//$order = $api->order(array('service' => 1, 'link' => 'http://example.com/test', 'quantity' => 100, 'runs' => 10, 'interval' => 60)); # Drip-feed

# return status, charge, remains, start count, order_id
//$status = $api->status(23);

# return orders status, charge, remains, start count, order_id
//$statuses = $api->multi_status([12, 2, 13]);