<?php

namespace helpers;
class NegaHubHelpers {
	private $result;
	private $statusCode;
	
	/**
	 * NegaHubHelpers constructor.
	 *
	 * @param $result
	 * @param $statusCode
	 */
	public function __construct($result, $statusCode) {
		$this->result = $result;
		$this->statusCode = $statusCode;
	}
	
	public static function callApiWithToken(string $path, string $method = 'get', array $body = []) : NegaHubHelpers {
        [
            $result,
            $code,
            $curl,
        ] = CallAPI($method, \FwConfig::ClubBasePath() . $path, $body, ['token' => \FwConfig::ClubToken()]);
//		[
//			$result,
//			$code,
//			$curl,
//		] = CallAPI('post', "https://api.negarine.com/", [
//			'body'    => $body,
//			'headers' => ['token' => \FwConfig::ClubToken(),],
//			'method'  => $method,
//		]);
		return new NegaHubHelpers($result, $code);
	}
	
	/**
	 * @return mixed
	 */
	public function getStatusCode() {
		return $this->statusCode;
	}
	
	public function decodeResult() {
		return json_decode($this->getResult());
	}
	
	/**
	 * @return mixed
	 */
	public function getResult() {
		return $this->result;
	}
}
