<?php
namespace helpers;
use FwHtml\Elements\Tags\Main\HtmlTags;

final class PaymentTypeHelper {

    static protected $arrayOfDays = [
        '3' => [
            'name' => 'پرداخت اینترنتی',
            'image' => 'online.svg',
            'active'=> true,
        ],
        '6' => [
            'name' => 'هدیه',
            'image' => 'gift.svg',
            'active'=> false,
        ],
        '7' => [
            'name' => 'کیف پول',
            'image' => 'credit.svg',
            'active'=> true,
        ],
        '8' => [
            'name' => 'پرداخت در محل',
            'image' => 'inCash.svg',
            'active'=> true,
        ],
    ];
    public static function toOption(bool $selected = true) {
        $output = [HtmlTags::Option()->Content("لطفا یک مورد را انتخاب کنید")->Selected()->Disabled()];
        foreach (self::toArray() as $key => $item){
            $output[] = HtmlTags::Option()->Value($key)->Content($item['name']);
        }
        return implode('',$output);
    }

    public static function toArray() {
        return self::$arrayOfDays;
    }

    public static function toApi() {
        $output = [];
        foreach (self::toArray() as $key => $value){
            if ($value['active']) {
                $output[] = ['id' => $key, 'name' => $value['name'], 'image' => "https://" . \FwConfig::HOST() . '/src/images/PaymentMethods/' . $value['image'],];
            }
        }
        return $output;
    }

	public static function toString($type) {
		return self::$arrayOfDays[$type]['name'];
    }
}
