<?php

namespace DATABASE;

use stdClass;
use FwConnection;
use FwCollection\src\BaseCollection;
use FwHtml\Elements\Tags\Main\HtmlTags;
use DATABASE\ORM\QueryBuilder\DBCollection;
use DATABASE\ORM\Interact\Entities\EntityScheme;

abstract class Model {
	public $_table;
	public $_key;
	public $_Entity;
	
	public function __construct() {
		if ($this->_table == NULL) {
			$this->_table = 'tbl' . collect(explode('\\', get_class($this)))->last();
		}
		if ($this->_Entity and class_exists($this->_Entity)) {
			$entity = new $this->_Entity();
			if ($entity instanceof EntityScheme) {
				$this->_Entity = $entity;
			}
		} else {
			$this->_Entity = new stdClass();
		}
		$this->onBoot();
	}
	
	public function onBoot() {
	}
	
	/**
	 * @return BaseCollection
	 */
	public static function getAllActives() {
		$instance = static::instance();
		$table = $instance->_table;
		$key = $instance->_key;
		$res = FwConnection::conn()->query("select * from `$table` as tbl left join `tblActiveList` as actives on tbl.$key = actives.item_id where actives.table_name = '$table'");
		$output = [];
		while ($row = $res->fetchObject(get_class($instance->_Entity))) {
			$output[] = $row;
		}
		return collect($output);
	}
	
	/**
	 * @return static
	 */
	public static function instance() {
		return new static();
	}
	
	public static function LastId() {
		$instance = static::instance();
		return ORM\QueryBuilder\QueryBuilder\Db::table($instance->_table)->orderBy($instance->_key, true)->limit(1)->get()->first()->{$instance->_key};
	}
	
	public static function GetLabelData($label) {
		$instance = static::instance();
		$form = $instance->_table;
		$form = str_replace('tbl', '', $form);
		if (FwConnection::conn()->query("SELECT * FROM Labels where form = '$form' and label_text like '$label'")->rowCount() > 0) {
			return FwConnection::conn()->query("SELECT * FROM Labels where form = '$form' and label_text like '$label'")->fetchObject()->label_details;
		}
		return '';
	}

    public static function toOption(bool $showEmpty = true, iterable $data = NULL) {
        $output = [];
        if ($showEmpty) {
            $output[] = self::EmptyOption();
        }
        if ($data === NULL) $data = static::getAll();
        /** @var EntityScheme $entity_scheme */
        foreach ($data as $entity_scheme) {
            $output[] = $entity_scheme->toOption();
        }
        return implode('', $output);
    }

    public static function Db() {
        $instance = static::instance();
        return ORM\QueryBuilder\QueryBuilder\Db::tableFromEntity($instance->_table, $instance->_Entity);
    }

	
	/**
	 * @param array|int|string $id
	 * @param array $array
	 *
	 * @return EntityScheme|false|stdClass
	 */
	public static function edit($id, array $array) {
		$id = is_array($id) ? $id : [$id];
		$instance = static::instance();
		if (ORM\QueryBuilder\QueryBuilder\Db::tableFromEntity($instance->_table, $instance->_Entity)->whereIn($instance->_key, $id)->update($array)) {
			return static::get($id);
		}
		return false;
	}
	
	/**
	 * @param array|int|string $id
	 *
	 * @return stdClass|EntityScheme|DBCollection
	 */
	public static function get($id) {
		$id = is_array($id) ? $id : [$id];
		$instance = static::instance();
		$res = ORM\QueryBuilder\QueryBuilder\Db::tableFromEntity($instance->_table, $instance->_Entity)->whereIn("{$instance->_key}", $id);
//        echo $res->showQuery();
		$res = $res->get();
		if ($res->length() > 1) {
			return $res;
		}
		return $res->first();
	}
	
	/**
	 * @param array|int|string $id
	 *
	 * @return bool
	 */
	public static function delete($id) {
		$id = is_array($id) ? $id : [$id];
		$instance = static::instance();
		return ORM\QueryBuilder\QueryBuilder\Db::tableFromEntity($instance->_table, $instance->_Entity)->whereIn($instance->_key, $id)->delete();
	}
	
	/**
	 * @param array $array
	 * @param string $operator
	 *
	 * @return EntityScheme|DBCollection|ORM\QueryBuilder\QueryBuilder\Db|stdClass
	 */
	public static function findOrCreate(array $array, string $operator = 'and') {
		$instance = static::instance();
		$db = ORM\QueryBuilder\QueryBuilder\Db::tableFromEntity($instance->_table, $instance->_Entity);
		if ($operator == 'and') {
			$res = $db->where($array);
		} elseif ($operator == 'or') {
			$res = $db->orWhere($array);
		}
		if (isset($res)) {
			if ($first = $res->get()->first()) {
				return $first;
			} else {
				if ($id = static::add($array)) {
					return static::get($id);
				}
			}
		}
		return NULL;
	}
	
	/**
	 * @param array $array
	 *
	 * @return bool|int
	 */
	public static function add(array $array) {
		$instance = static::instance();
		return ORM\QueryBuilder\QueryBuilder\Db::tableFromEntity($instance->_table, $instance->_Entity)->insertWithId($array);
	}
	
	public static function findOrNew(array $array) {
		$instance = static::instance();
		$db = ORM\QueryBuilder\QueryBuilder\Db::tableFromEntity($instance->_table, $instance->_Entity);
		$res = $db->where($array)->get()->first();
		if ($res) {
			return $res;
		}
		$entity = $instance->_Entity;
		foreach ($array as $key => $value) {
			$entity->$key = $value;
		}
		return $entity;
	}
	
	public static function getAllFiltered(string $filterField, $filterValue) {
		$instance = static::instance();
		$db = ORM\QueryBuilder\QueryBuilder\Db::tableFromEntity($instance->_table, $instance->_Entity);
		return $db->where($filterField, $filterValue)->get();
	}
	
	public static function getOneFiltered(string $filterField, string $filterValue) {
		$instance = static::instance();
		$db = ORM\QueryBuilder\QueryBuilder\Db::tableFromEntity($instance->_table, $instance->_Entity);
		return $db->where($filterField, $filterValue)->get()->first();
	}
	
	public static function getAllConditioned(string $condition) {
		$instance = static::instance();
		$db = ORM\QueryBuilder\QueryBuilder\Db::tableFromEntity($instance->_table, $instance->_Entity);
		return $db->where($condition)->get();
	}
	
	public static function Rand() {
		$instance = static::instance();
		$db = ORM\QueryBuilder\QueryBuilder\Db::tableFromEntity($instance->_table, $instance->_Entity);
		return $db->orderBy('RAND()')->get()->first();
	}
	
//	public static function toOption(bool $showEmpty = true, iterable $data = NULL) {
//		$output = [];
//		if ($showEmpty) {
//			$output[] = self::EmptyOption();
//		}
//		if ($data === NULL) $data = self::getAll();
//		/** @var EntityScheme $entity_scheme */
//		foreach ($data as $entity_scheme) {
//			$output[] = $entity_scheme->toOption();
//		}
//		return implode('', $output);
//	}
	
	/**
	 * Model constructor.
	 */
	protected static function EmptyOption() {
		return HtmlTags::Option()->Value('')->Selected()->Disabled()->Content("لطفا یک مورد را انتخاب کنید");
	}
	
	/**
	 * @return ORM\QueryBuilder\DBCollection
	 */
	public static function getAll() {
		$instance = static::instance();
		return ORM\QueryBuilder\QueryBuilder\Db::tableFromEntity($instance->_table, $instance->_Entity)->get();
	}
	
	/**
	 * @return false|string
	 */
	public function __toString() {
		return get_class($this);
	}
}
