<?php

namespace Pasargad\Classes;


class RequestBuilder
{
    /**
     * The API get method.
     *
     * @const string
     */
    const GET = 'GET';

    /**
     * The API post method.
     *
     * @const string
     */
    const POST = 'POST';

    /**
     * The request.
     *
     */
    protected $internalCurl;

    /** @var array $headers */
    protected $headers;

    /** @var array $options */
    protected $options = [];

    /**
     * RequestBuilder Class constructor.
     */
    public function __construct()
    {
        $this->internalCurl = curl_init();
    }

    /**
     * Build request.
     *
     * @param string $url The url.
     * @param string $method The method.
     * @param array $body The body.
     *
     * @return bool|array Return response.
     *
     * @throws \Exception Throw on unsupported $method use.
     * @throws \Exception Throw on API return invalid response.
     */
    public function send($url, $method = self::POST, array $headers = [], array $body = [], $encodeJson = false, $safeMode = true)
    {
        curl_reset($this->internalCurl);
        foreach ($this->options as $option => $value) {
            curl_setopt($this->internalCurl, $option, $value);
//            $this->internalCurl->setOpt($option, $value);
        }

        curl_setopt($this->internalCurl, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Accept: application/json',
        ]);

        // Disable Certificate checking in Curl
        if (!$safeMode) {
            curl_setopt($this->internalCurl, CURLOPT_SSL_VERIFYPEER, false);
        }

        foreach ($headers as $headerKey => $headerValue) {
            curl_setopt($this->internalCurl, CURLOPT_HTTPHEADER, [
                "$headerKey: $headerValue"
            ]);

//            $this->internalCurl->setHeader($headerKey, $headerValue);
        }
        switch ($method) {
            case self::GET:
                curl_setopt($this->internalCurl, CURLOPT_CUSTOMREQUEST, 'GET');

                break;
            case self::POST:
                curl_setopt($this->internalCurl, CURLOPT_POSTFIELDS, $encodeJson ? json_encode($body) : $body);
                curl_setopt($this->internalCurl, CURLOPT_CUSTOMREQUEST, 'POST');
                break;
            default:
                throw new \Exception('Not supported method ' . $method . '.');
        }

        curl_setopt($this->internalCurl, CURLOPT_URL, $url);
        curl_setopt($this->internalCurl, CURLOPT_RETURNTRANSFER, true);
        $res = curl_exec($this->internalCurl);
        if (
            curl_error($this->internalCurl)) {
            throw new \Exception(
                curl_error($this->internalCurl),
                curl_errno($this->internalCurl)
            );
        }
        curl_close($this->internalCurl);
        if (false === empty($res)) {
            $json = json_decode($res, true);
            if ($json === null) {
                throw new \Exception(json_last_error_msg(), json_last_error());
            }
            if (!$json['IsSuccess']) {
                throw new \Exception($json['Message']);
            }
            return $json;
        }

        return true;
    }
}
